% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nkde_execution_functions.R
\name{nkde.mc}
\alias{nkde.mc}
\title{Network Kernel density estimate (multicore)}
\usage{
nkde.mc(
  lines,
  events,
  w,
  samples,
  kernel_name,
  bw,
  adaptive = FALSE,
  trim_bw = NULL,
  method,
  div = "bw",
  diggle_correction = FALSE,
  study_area = NULL,
  max_depth = 15,
  digits = 5,
  tol = 0.1,
  agg = NULL,
  sparse = TRUE,
  grid_shape = c(1, 1),
  verbose = TRUE,
  check = TRUE
)
}
\arguments{
\item{lines}{A SpatialLinesDataFrame with the sampling points. The
geometries must be a SpatialLinesDataFrame (may crash if some geometries
 are invalid)}

\item{events}{A SpatialPointsDataFrame representing the events on the
network. The points will be snapped on the network.}

\item{w}{A vector representing the weight of each event}

\item{samples}{A SpatialPointsDataFrame representing the locations for
which the densities will be estimated}

\item{kernel_name}{The name of the kernel to use. Must be one of triangle,
gaussian, tricube, cosine ,triweight, quartic, epanechnikov or uniform.}

\item{bw}{The kernel bandwidth (in meters)}

\item{adaptive}{A Boolean, indicating if an adaptive bandwidth must be
used}

\item{trim_bw}{A float, indicating the maximum value for the adaptive
bandwidth}

\item{method}{The method to use when calculating the NKDE, must be one of
simple / discontinuous / continuous (see details for more information)}

\item{div}{The divisor to use for the kernel. Must be "n" (the number of
events within the radius around each sampling point), "bw" (the bandwith)
"none" (the simple sum).}

\item{diggle_correction}{A Boolean indicating if the correction factor
for edge effect must be used.}

\item{study_area}{A SpatialPolygonsDataFrame or a SpatialPolygon
representing the limits of the study area.}

\item{max_depth}{when using the continuous and discontinuous methods, the
calculation time and memory use can go wild  if the network has many
small edges (area with many of intersections and many events). To
avoid it, it is possible to set here a maximum depth. Considering that the
kernel is divided at intersections, a value of 10 should yield good
estimates in most cases. A larger value can be used without problem for the
discontinuous method. For the continuous method, a larger value will
strongly impact calculation speed.}

\item{digits}{The number of digits to retain in the spatial coordinates. It
ensures that topology is good when building the network. Default is 3}

\item{tol}{When adding the events and the sampling points to the network,
the minimum distance between these points and the lines' extremities. When
points are closer, they are added at the extremity of the lines.}

\item{agg}{A double indicating if the events must be aggregated within a distance.
If NULL, the events are aggregated by rounding the coordinates.}

\item{sparse}{A Boolean indicating if sparse or regular matrix should be
used by the Rcpp functions. Regular matrix are faster, but require more
memory and could lead to error, in particular with multiprocessing. Sparse
matrix are slower, but require much less memory.}

\item{grid_shape}{A vector of two values indicating how the study area
must be split when performing the calculus (see details). Default is c(1,1)}

\item{verbose}{A Boolean, indicating if the function should print messages
about process.}

\item{check}{A Boolean indicating if the geometry checks must be run before
calculating the density.}
}
\value{
A vector of values, they are the density estimates at sampling
points
}
\description{
Calculate the Network Kernel Density Estimate based on a network of lines,
sampling points, and events with multicore support. For details, please see the function nkde
}
\examples{
\dontrun{
networkgpkg <- system.file("extdata", "networks.gpkg", package = "spNetwork", mustWork = TRUE)
eventsgpkg <- system.file("extdata", "events.gpkg", package = "spNetwork", mustWork = TRUE)
mtl_network <- rgdal::readOGR(networkgpkg,layer="mtl_network", verbose=FALSE)
bike_accidents <- rgdal::readOGR(eventsgpkg,layer="bike_accidents", verbose=FALSE)
future::plan(future::multisession(workers=2))
lixels <- lixelize_lines(mtl_network,200,mindist = 50)
samples <- lines_center(lixels)
densities <- nkde.mc(mtl_network,
                  events = bike_accidents,
                  w = rep(1,nrow(bike_accidents)),
                  samples = samples,
                  kernel_name = "quartic",
                  bw = 300, div= "bw",
                  adaptive = FALSE, agg = 15,
                  method = "discontinuous", digits = 1, tol = 1,
                  grid_shape = c(3,3),
                  verbose=FALSE)
## make sure any open connections are closed afterward
if (!inherits(future::plan(), "sequential")) future::plan(future::sequential)
}
}
