% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{applyChanges}
\alias{applyChanges}
\title{Apply a series of sound changes to a vector of characters strings.}
\usage{
applyChanges(data, changes, target = NULL, meta = NULL)
}
\arguments{
\item{data}{[character] The strings to which to apply the changes.}

\item{changes}{[soundchange] The list of \code{\link{soundchange}}'s to apply.}

\item{target}{[character] The strings to which to compare the results. Defaults to \code{NULL}.}

\item{meta}{[list] Additional metadata to pass to \code{\link{soundchange}} functions. Must be the same length as \code{data}. Defaults to \code{NULL}.}
}
\value{
[list.applyChanges] A list with three fields: \code{$end}, a named list with the final results; \code{$match}, a named list with one of three values: \code{0} when none of the final results matches the \code{target}, \code{0.5} when at least one of the final results matches the \code{target}, or \code{1} when all the final results match the \code{target}; lastly \code{$tree}, a list tracing all the intermediate forms.
}
\description{
Apply a list of \code{\link{soundchange}}'s to a vector of charcter strings, possibly with additional metadata, and possibly compare the results to a prediction.
}
\details{
Functions in \code{\link{soundchange}} objects are allowed to return more than one value, which makes manual application of a series of changes highly inconvenient and prone to errors. This function automates the process, while keeping track of all the intermediate forms. It returns the result in three formats: only the final shapes, their comparison to the shapes given under the \code{target} argument, and a tree with all the steps along the way. By default, only the final shapes are printed. The other two formats are accessible as simply elements of a named list.

Note that the application of sound changes does not require the data to be segmented and aligned. If sound changes are the only goal of the project, these two time-consuming steps can be safely omitted.
}
\examples{
# prepare sample transcription
trans <- loadSampleDataset ("trans-common")
# define sound changes and data
i2a <- soundchange ("i > a", "lowering", trans)
a2u <- soundchange ("a > u", "backing", trans)
dataset <- c ("begin", "ring", "swim")
# apply the changes
applyChanges (dataset, list(i2a,a2u))
applyChanges (dataset, list(i2a,a2u))$tree
}
\seealso{
\code{\link{print.list.applyChanges}}, \code{\link{print.tree.applyChanges}}
}
