% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{allCooccs}
\alias{allCooccs}
\title{Generate all co-occurrence contingency tables for a dataset.}
\usage{
allCooccs(data, column, count, unit, bin)
}
\arguments{
\item{data}{[soundcorrs] The dataset from which to draw frequencies. Only datasets with two languages are supported.}

\item{column}{[character] Name of the column with metadata. If \code{NULL}, sound correspondences are cross-tabulated with themselves. Defaults to \code{NULL}.}

\item{count}{[character] Report the absolute number of times or words, or relative to how many times or in how many words the given segments co-occur in L1 or L2. Accepted values are \code{"a(bs(olute))"} and \code{"r(el(ative))"}. Defaults to "a".}

\item{unit}{[character] Count how many times a correspondence occurs or in how many words it occurs. Accepted values are \code{"o(cc(ur(ence(s))))"} and \code{"w(or(d(s)))"}. Defaults to \code{"w"}.}

\item{bin}{[logical] Whether to bin tables before applying \code{fun} to them. Defaults to \code{TRUE}.}
}
\value{
[list] A list of tables.
}
\description{
Generate all correspondence-to-correspondence or correspondence-to-metadata contingnecy tables for a dataset.
}
\details{
A contingency table such as produced by \code{\link{coocc}} may be insightful but more often than not statistical tests cannot be applied directly to it, or at least they would not produce meaningful results. This function splits such a table into blocks such that each block only contains the correspondences of a single segment. The resulting slices, additionally binned or not (cf. \code{\link{binTable}}), can be then passed to \code{\link{lapplyTest}} for a near-automatic application of a test.
}
\examples{
dataset <- loadSampleDataset ("data-abc")
allCooccs (dataset)
allCooccs (dataset, "DIALECT.L2", unit="o")
}
\seealso{
\code{\link{coocc}}, \code{\link{binTable}}, \code{\link{lapplyTest}}
}
