\name{Constants}

\alias{Constants}
\alias{gmlBeginName}
\alias{gmlBeginPositionName}
\alias{gmlBoundedByName}
\alias{gmlDescriptionName}
\alias{gmlDurationName}
\alias{gmlEndName}
\alias{gmlEndPositionName}
\alias{gmlEnvelopeName}
\alias{gmlFeatureCollectionName}
\alias{gmlFeatureMemberName}
\alias{gmlLowerCornerName}
\alias{gmlNameName}
\alias{gmlNamespacePrefix}
\alias{gmlPointName}
\alias{gmlPosName}
\alias{gmlRelatedTimeName}
\alias{gmlTimeInstantName}
\alias{gmlTimeIntervalName}
\alias{gmlTimeLengthName}
\alias{gmlTimePeriodName}
\alias{gmlTimePositionName}
\alias{gmlUpperCornerName}
\alias{ogcBBOXName}
\alias{ogcArithmeticOperatorsName}
\alias{ogcComparisonOpBetweenName}
\alias{ogcComparisonOpEqualToName}
\alias{ogcComparisonOpGreaterThanName}
\alias{ogcComparisonOpGreaterThanOrEqualToName}
\alias{ogcComparisonOpLessThenName}
\alias{ogcComparisonOpLessThanOrEqualToName}
\alias{ogcComparisonOpIsLikeName}
\alias{ogcComparisonOpIsNotEqualTo}
\alias{ogcComparisonOpIsNull}
\alias{ogcContainsName}
\alias{ogcEIDName}
\alias{ogcFIDName}
\alias{ogcGeometryOperandName}
\alias{ogcGeometryOperandsName}
\alias{ogcIdCapabilities}
\alias{ogcGeometryOperandEnvelopeName}
\alias{ogcGeometryOperandPolygonName}
\alias{ogcGeometryOperandPointName}
\alias{ogcGeometryOperandLineStringName}
\alias{ogcIntersectsName}
\alias{ogcLiteralName}
\alias{ogcLogicalOperatorsName}
\alias{ogcNamespacePrefix}
\alias{ogcOverlapsName}
\alias{ogcPropertyNameName}
\alias{ogcScalarCapabilitiesName}
\alias{ogcSpatialCapabilitiesName}
\alias{ogcSpatialOperatorName}
\alias{ogcSpatialOperatorsName}
\alias{ogcSpatialOpBBOXName}
\alias{ogcSpatialOpContainsName}
\alias{ogcSpatialOpIntersectsName}
\alias{ogcSpatialOpOverlapsName}
\alias{ogcSpatialOpBeyondName}
\alias{ogcSpatialOpCrossesName}
\alias{ogcSpatialOpDWithinName}
\alias{ogcSpatialOpDisjointName}
\alias{ogcSpatialOpEqualsName}
\alias{ogcSpatialOpTouchesName}
\alias{ogcSpatialOpWithinName}
\alias{ogcTempOpTMAfterName}
\alias{ogcTempOpTMBeforeName}
\alias{ogcTempOpTMBeginsName}
\alias{ogcTempOpTMBegunByName}
\alias{ogcTempOpTMContainsName}
\alias{ogcTempOpTMDuringName}
\alias{ogcTempOpTMEndedByName}
\alias{ogcTempOpTMEndsName}
\alias{ogcTempOpTMEqualsName}
\alias{ogcTempOpTMMeetsName}
\alias{ogcTempOpTMMetByName}
\alias{ogcTempOpTMOverlapsName}
\alias{ogcTempOpTTMOverlappedBy}
\alias{ogcTemporalCapabilitiesName}
\alias{ogcTemporalOperandsName}
\alias{ogcTemporalOperandName} 
\alias{ogcTemporalOperatorsName}
\alias{ogcTemporalOperatorName}
\alias{omMeasurementName}
\alias{omMemberName}
\alias{omObservationName}
\alias{omObservationCollectionName}
\alias{omFeatureOfInterestName}
\alias{omProcedureName}
\alias{omObservedPropertyName}
\alias{omResultTimeName}
\alias{omSamplingTimeName}
\alias{omResultName}
\alias{omCategoryObservationName}
\alias{omCountObservationName}
\alias{omTruthObservationName}
\alias{omGeometryObservationName}
\alias{omTemporalObservationName}
\alias{omComplexObservationName}
\alias{saSamplingPointName}
\alias{saSamplingSurface}
\alias{saPositionName}
\alias{saSampledFeatureName}
\alias{saSamplingTimeName}
\alias{owsServiceIdentificationName}
\alias{owsTitleName}
\alias{owsAbstractName}
\alias{owsKeywordsName}
\alias{owsKeywordName}
\alias{owsServiceTypeName}
\alias{owsServiceTypeVersionName}
\alias{owsFeesName}
\alias{owsAccessConstraintsName}
\alias{owsServiceProviderName}
\alias{owsOperationsMetadataName}
\alias{owsOperationName}
\alias{owsDCPName}
\alias{owsHTTPName}
\alias{owsGetName}
\alias{owsPostName}
\alias{owsParameterName}
\alias{owsAllowedValuesName}
\alias{owsValueName}
\alias{owsAnyValueName}
\alias{owsRangeName}
\alias{owsMinimumValueName}
\alias{owsMaximumValueName}
\alias{owsSpacingName}
\alias{owsConstraintName}
\alias{owsMetadataName}
\alias{owsExceptionName}
\alias{owsExceptionTextName}
\alias{owsProfileName}
\alias{owsProviderNameName}
\alias{owsProviderSiteName}
\alias{owsServiceContactName}
\alias{saSamplingPointName}
\alias{saSamplingSurface}
\alias{saPositionName}
\alias{saSampledFeatureName}
\alias{saSamplingTimeName}
\alias{sosService}
\alias{sosNamespacePrefix}
\alias{sosGetCapabilitiesName}
\alias{sosDescribeSensorName}
\alias{sosGetObservationName}
\alias{sosGetObservationByIdName}
\alias{owsExceptionReportName}
\alias{sosGetFeatureOfInterestName}
\alias{sosIntendedApplicationName}
\alias{sosTimeName}
\alias{sosProcedureName}
\alias{sosObservedPropertyName}
\alias{sosFeatureOfInterestName}
\alias{sosResultModelName}
\alias{sosResponseFormatName}
\alias{sosResponseModeName}
\alias{sosObservationOfferingName}
\alias{sosObservationOfferingListName}
\alias{sosContentsName}
\alias{sosFilterCapabilitiesName}
\alias{sosCapabilitiesName}
\alias{sosEventTimeName}
\alias{sosEventTimeLatestValue}
\alias{sosObjectIDName}
\alias{sosResultName}
\alias{sweCompositePhenomenonName}
\alias{sweBaseName}
\alias{sweComponentName}
\alias{sweDataArrayName}
\alias{sweElementTypeName}
\alias{sweSimpleDataRecordName}
\alias{sweDataRecordName}
\alias{sweFieldName}
\alias{sweTimeName}
\alias{sweQuantityName}
\alias{sweCategoryName}
\alias{sweBooleanName}
\alias{sweCountName}
\alias{sweEncodingName}
\alias{sweTextBlockName}
\alias{sweValuesName}
\alias{sweValueName}
\alias{sweCodeSpaceName}
\alias{sweTextName}
\alias{sweUomName}
\alias{sweCoordinateName}
\alias{sweLocationName}
\alias{swePositionName}
\alias{sweVectorName}
\alias{xmlInternalDocumentName}
\alias{xmlTextNodeName}
\alias{OwsExceptionsData}
\alias{ogcComparisonOperatorsName}
\alias{ogcTempOpTMOverlappedBy}
\alias{owsNamespacePrefix}
\alias{sosDescribeFeatureTypeName}
\alias{sosDescribeObservationTypeName}
\alias{sosDescribeResultModelName}
\alias{sosGetFeatureOfInterestTimeName}
\alias{sosGetResultName}
\alias{sosInsertObservationName}
\alias{sosRegisterSensorName}
  
\alias{mimeTypeCSV}
\alias{mimeTypeOM}
\alias{mimeTypeSML}
\alias{mimeTypeXML}


\title{Constants in sos4R}

\description{
The package \pkg{sos4R} comes with a set of constant character strings and fixed supported features, for example for names of XML elements, XML Namespace prefixes, or supported formats and models.
}

\details{
Most of these variables should be pretty self-explanatory.

Constants for names of XML elements start with a lowercase character string of the namespace prefix (e.g. "gml"), a unique name of the element (where parts like "type" and special characters may be left out, and other descripte elements may be added for clarity), and end with "Name".

Examples: code{gmlEnvelopeName}, \code{ogcGeometryOperandLineStringName}, \code{ogcTempOpTMEqualsName}.

The \code{OwsExceptionsData()} function provides access to the fixed exception codes, meanings and respective HTTP codes and messages. 
}

\references{See also \code{\link{Defaults}} for default parameter settings.

Whiteside A. (Ed.), OGC Web Services Common Specification, Open Geospatial Consortium Inc., OGC 06-121r3, Version: 1.1.0 with Corrigendum 1
}

\examples{

# example constants
sosNamespacePrefix
gmlNameName
sweUomName

# Data frame holding OWS exception code information
OwsExceptionsData()
}

\keyword{constants}
\keyword{XML}
