\name{PackageSum2}
\alias{PackageSum2}
\alias{PackageSum2.findFn}
\alias{PackageSum2.data.frame}
\alias{PackageSum2.list}
\title{
  Add Info from Installed Packages to PackageSummary
}
\description{
  Add information on installed packages to the 
  \code{PackageSummary} of a \code{findFn} object.
}
\usage{
PackageSum2(x,
    fields=c("Title", "Version", "Author", "Maintainer", 
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{PackageSum2}{findFn}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{PackageSum2}{data.frame}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{PackageSum2}{list}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
}
\arguments{
  \item{x}{
    a data.frame with columns \code{Package} and 
    \code{Score}.
  }
  \item{fields}{
    character vector of names of columns to add to
    \code{x}. The function first looks  in the components
    of \code{packageDescription(x$Package[i])}.  
    'vignette' is obtained via the function of that name.

    Component 'Packaged' receives special treatment.  If
    present, only the portion preceding ';' will be 
    retained.  This seems to be a time stamp automatically
    generated by something like \code{R CMD build}.  It is
    absent for packages automatically loaded when R is
    started.  In such cases, the third component of 
    \code{strsplit(packageDescription( 
    x$Package[i])$Built, ..., ';')} will be stored as
    'Packaged'.  This seems to be a time stamp 
    automatically generated by something like 
    \code{R CMD INSTALL --build}.
  }
  \item{lib.loc}{
    an optional \code{lib.loc} argument passed to
    \code{packageDescription}.
  }
  \item{\dots}{
    additional arguments (currently unused)
  }
}
\details{
  With an object of class \code{findFn}, extract the
  \code{PackageSummary} attribute and pass it to the 
  \code{data.frame} method.

  With an object of class \code{list}, extract the 
  \code{PackageSummary} component and pass it to the 
  \code{data.frame} method.

  For a \code{data.frame} that is not an \code{findFn} 
  object, add other columns from \code{attributes} of 
  \code{packageDescription} for installed packages named
  in the column \code{Package}.  Also, for any packages
  that are installed, replace the \code{Date} with the
  \code{Packaged} date.  The \code{Date} in Baron's
  RSiteSearch database is the date of acquisition, which
  will typically be more recent than the \code{Packaged}
  date provided the locally installed package has the same
  version as that in Baron's database.  To get the best
  information from \code{PackageSum2}, it is wise to first
  run both \code{\link{installPackages}} to ensure that
  the packages of greatest interest are installed locally
  and \code{update.packages()} to make sure you have the 
  latest versions installed locally.  Similarly, if
  \code{PackageSum2} does not contain complete interest on
  a package of interest, this can be fixed by installing
  the package and rerunning \code{PackageSum2}.
}
\value{
  a data.frame with additional \code{fields} columns
  appended to a \code{\link{PackageSummary}}
  \code{\link{data.frame}}.
}
\author{Spencer Graves}
\seealso{
  \code{\link{packageSum}}, which does essentially the
    same thing but returns an object of class 
    \code{packageSum}.  
  \code{\link{findFn}}
  \code{\link{PackageSummary}}
  \code{\link{installPackages}}
}
\examples{
##
## data.frame method
##
Tstdf <- data.frame(Package=c('grid', 'base'), 
            stringsAsFactors=FALSE)
Tst2 <- PackageSum2(Tstdf)

##
## list method
##
TstList <- list(PackageSummary=Tstdf)
\dontshow{stopifnot(}
all.equal(Tst2, PackageSum2(TstList))
\dontshow{)}

##
## findFn method
##
Tst.findFn <- data.frame(
    Package=c('grid', 'base')[c(1,1,2)], 
    Score=2:4, Date=LETTERS[1:3], stringsAsFactors=FALSE)
attr(Tst.findFn, 'PackageSummary') <- PackageSummary(
    Tst.findFn)
class(Tst.findFn) <- c('findFn', 'data.frame')
Tst2. <- PackageSum2(Tst.findFn)

\dontshow{stopifnot(}
all.equal(Tst2, Tst2.[names(Tst2)])
\dontshow{)}

}
\keyword{package}
