\name{h2}
\alias{h2}
\docType{data}
\title{
Broad sense heritability calculation.
}
\description{
This dataset contains phenotpic data for 41 potato lines evaluated in 5 locations across 3 years in an RCBD design. The phenotypic trait is tuber quality and we show how to obtain an estimate of h2 for the trait.

}
\usage{data("h2")}
\format{
  The format is:
 chr "h2"
}
\source{
This data was generated by a potato study.
}
\references{

Covarrubias-Pazaran G (2016) Genome assisted prediction of quantitative traits using the R package sommer. PLoS ONE 11(6): doi:10.1371/journal.pone.0156744 

}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(h2)
head(h2)
####=========================================####
#### fit the mixed model and extract var.comp
####=========================================####
#ans1 <- mmer2(y~1, random=~Name + Env + Name:Env + Block,data=h2, method="NR")
#vc <- ans1$var.comp
#V_E <- vc[2,1];V_GE <- vc[3,1];V_G <- vc[1,1];Ve <- vc[5,1]
####=========================================####
#### calculate heritability
####=========================================####
#n.env <- length(levels(h2$Env))
#h2c <- V_G/(V_G + V_GE/n.env + Ve/(2*n.env)) #the 2 is a reference for block
#h2c
}
\keyword{datasets}
\seealso{The core function of the package \code{\link{mmer}}}
