\name{FDdata}
\alias{FDdata}
\docType{data}
\title{
half diallel data for corn hybrids
}
\description{
This dataset contains phenotpic data for 36 winter bean hybrids, coming from a full diallel design and evaluated for 9 traits. The column male and female origin columns are included as well. 

}
\usage{data("FDdata")}
\format{
  The format is:
 chr "FDdata"
}
\source{
This data was generated by a winter bean study and originally included in the agridat package.
}
\references{
Covarrubias-Pazaran G (2016) sommer: An R package for mixed model analysis education. R package version 1.1. URL https://cran.r-project.org/web/packages/sommer/.
}
\examples{
####=========================================####
#### For CRAN time limitations most lines in the 
#### examples are silenced with one '#' mark, 
#### remove them and run the examples
####=========================================####
data(FDdata)
head(FDdata)
mix <- mmer2(stems~1, random=~female+male, data=FDdata)
summary(mix)

####=========================================####
#### using mmer function would be like
####=========================================####
Z1 <- model.matrix(~female-1, data=FDdata)
Z2 <- model.matrix(~male-1, data=FDdata)
ETA <- list(GCA1=list(Z=Z1), GCA2=list(Z=Z2))
y <- FDdata$stems
mix2 <- mmer(y=y, Z=ETA, method = "NR")
summary(mix2)


}
\keyword{datasets}
