% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadratic_plateau.R
\name{quadratic_plateau}
\alias{quadratic_plateau}
\alias{SS_QP}
\alias{boot_quadratic_plateau}
\title{Quadratic-plateau response function}
\usage{
SS_QP(x, a, b, xs)

quadratic_plateau(
  data = NULL,
  stv,
  ry,
  target = NULL,
  tidy = TRUE,
  plot = FALSE,
  resid = FALSE
)

boot_quadratic_plateau(data, stv, ry, n = 1000, target = NULL, ...)
}
\arguments{
\item{x}{selfstart arg. for explanatory variable in SSquadp3xs Default: NULL}

\item{a}{selfstart arg. for intercept Default: NULL}

\item{b}{selfstart arg. for slope Default: NULL}

\item{xs}{selfstart arg. for break/join point in SSquadp3xs Default: NULL}

\item{data}{Optional argument to call and object of type data.frame or data.table
containing the stv and ry data, Default: NULL}

\item{stv}{name of the vector containing soil test values (-) of type \code{numeric}.}

\item{ry}{name of the vector containing relative yield values (\%) of type \code{numeric}.}

\item{target}{\code{numeric} value of relative yield target (e.g. 90 for 90\%) to estimate the CSTV.
The target needs to be < plateau, otherwise, target = plateau.}

\item{tidy}{logical operator (TRUE/FALSE) to decide the type of return. TRUE returns a tidy data frame or tibble (default), FALSE returns a list.}

\item{plot}{logical operator (TRUE/FALSE) to plot the quadratic-plateau model, Default: FALSE}

\item{resid}{logical operator (TRUE/FALSE) to plot residuals analysis, Default: FALSE}

\item{n}{sample size for the bootstrapping Default: 500}

\item{...}{when running bootstrapped samples, the \code{...} (open arguments) allows to add grouping variable/s (factor or character) Default: NULL}
}
\value{
returns an object of type \code{ggplot} if plot = TRUE.

returns a residuals plot if resid = TRUE.

returns an object of class \code{data.frame} if tidy = TRUE,

returns an object of class \code{list} if tidy = FALSE.

SS_QP: selfStart function to pass into the quadratic_plateau fit

quadratic_plateau: function

boot_quadratic_plateau: bootstrapping function
}
\description{
This function helps to fit a quadratic-plateau response model and to
estimate a critical soil test values (CSTV) above which yield response becomes flat.
}
\details{
See \href{https://adriancorrendo.github.io/soiltestcorr/articles/quadratic_plateau_tutorial.html}{online-documentation} for additional details.
}
\note{
For extended reference, we recommend to visit
\url{https://gradcylinder.org/post/quad-plateau/} by Austin Pearce.
Self-start function code adapted from nlraa package by F. Miguez \url{https://github.com/femiguez/nlraa}
}
\examples{
\donttest{
# Example dataset
 df <- data.frame("ry" = c(65,80,85,88,90,94,93,96,97,95,98,100,99,99,100),
                  "stv" = c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15))
 # Run
 fit_example_qp <- quadratic_plateau(data = df, 
 stv = stv, ry = ry, resid = TRUE, plot = FALSE)
 fit_example_qp
}
}
\references{
Bullock, D.G. and Bullock, D.S. (1994)
Quadratic and Quadratic-Plus-Plateau Models for Predicting Optimal Nitrogen Rate of Corn: A Comparison.
\emph{Agron. J., 86: 191-195.} \doi{10.2134/agronj1994.00021962008600010033x}
}
\seealso{
\code{\link[rlang]{eval_tidy}},\code{\link[rlang]{defusing-advanced}}
\code{\link[minpack.lm]{nlsLM}}
\code{\link[nlraa]{SSlinp}}
\code{\link[stats]{AIC}},\code{\link[stats]{lm}},\code{\link[stats]{optim}},\code{\link[stats]{coef}},\code{\link[stats]{predict}}
\code{\link[AICcmodavg]{AICc}}
\code{\link[modelr]{model-quality}}
\code{\link[nlstools]{nlsResiduals}}
\code{\link[dplyr]{bind}}
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{geom_rug}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{geom_abline}},\code{\link[ggplot2]{geom_path}},\code{\link[ggplot2]{annotate}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{theme}}
\code{\link[ggpp]{annotate}}
}
