% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_colors_from_NASIS_db.R
\name{get_colors_from_NASIS_db}
\alias{get_colors_from_NASIS_db}
\title{Get Soil Color Data from a local NASIS Database}
\usage{
get_colors_from_NASIS_db(
  SS = TRUE,
  method = "dominant",
  mixColors = FALSE,
  dsn = NULL
)
}
\arguments{
\item{SS}{fetch data from Selected Set in NASIS or from the entire local
database (default: \code{TRUE})}

\item{method}{Aggregation method to handle multiple colors per horizon and moisture state. Default \code{"dominant"} for dominant condition (or first record) within moisture state. Other options include \code{"mixed"} to calculate mixture using \code{simplifyColorData()} and \code{"none"} to do no aggregation (returns a long format representation that may have multiple values per horizon and moisture state)}

\item{mixColors}{Deprecated. See \code{method}. Should mixed colors be calculated where multiple colors are populated for the same moisture state in a horizon? Default \code{FALSE} takes the dominant color based on \code{colorpct} or first record based on horizon ID (\code{phiid}) sorting for "moist" and "dry" state. Pedon Horizon Color records without a moisture state populated are ignored.}

\item{dsn}{Optional: path to local SQLite database containing NASIS
table structure; default: \code{NULL}}
}
\value{
A data.frame with the results.
}
\description{
Get, format, mix, and return color data from a NASIS database.
}
\seealso{
\code{\link{simplifyColorData}},
\code{\link{get_hz_data_from_NASIS_db}},
\code{\link{get_site_data_from_NASIS_db}}
}
\author{
Jay M. Skovlin and Dylan E. Beaudette
}
\keyword{manip}
