% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDA_properties.R
\name{get_SDA_property}
\alias{get_SDA_property}
\title{Get map unit properties from Soil Data Access}
\usage{
get_SDA_property(
  property,
  method,
  areasymbols = NULL,
  mukeys = NULL,
  top_depth = NULL,
  bottom_depth = NULL,
  FUN = NULL
)
}
\arguments{
\item{property}{a label or column name from property dictionary}

\item{method}{one of: "Dominant Component (Category)", "Weighted Average", "Min/Max", "Dominant Component (Numeric)", "Dominant Condition"#'}

\item{areasymbols}{vector of soil survey area symbols}

\item{mukeys}{vector of map unit keys}

\item{top_depth}{Optional: a numeric value for upper boundary (top depth) used for method="weighted average" and "dominant component (numeric)"}

\item{bottom_depth}{Optional: a numeric value for lower boundary (bottom depth) used for method="weighted average and "dominant component (numeric)"}

\item{FUN}{Optional: character representing SQL aggregation function either "MIN" or "MAX" for method="min/max"}
}
\value{
a data.frame with result
}
\description{
Get map unit properties from Soil Data Access
}
\author{
Jason Nemecek, Chad Ferguson, Andrew Brown
}
