% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.r
\name{prefix_replace}
\alias{prefix_replace}
\title{prefix_replace}
\usage{
prefix_replace(var_names, prefixes, replacements, toTitle = TRUE, ...)
}
\arguments{
\item{var_names}{A character vector, usually variable names}

\item{prefixes}{A character vector, usually variable prefixes}

\item{replacements}{A character vector of replacements for the
`prefixes`, in the same order as them.}

\item{toTitle}{Convert results to Title Case? Defaults to TRUE.}

\item{...}{Other arguments to `gsub`}
}
\value{
A character vector with `prefixes` terms in `var_names`
    replaced with the content of the `replacement` terms.
}
\description{
Replace series of characters (usually variable names) at the beginning of a character vector.
}
\details{
Takes a character vector (usually vector of variable names from a
    summarized or tidied model object), along with a vector of
    character terms (usually the prefix of a dummy or categorical
    variable added by R when creating model terms) and strips the
    latter away from the former. Useful for quickly cleaning
    variable names for a plot.
}
\examples{
prefix_replace(iris$Species, c("set", "ver", "vir"), c("sat",
    "ber", "bar"))
}
\author{
Kieran Healy
}
