% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-array.R, R/backend-generics.R,
%   R/backend-terra.R
\name{.check_x.array}
\alias{.check_x.array}
\alias{.has_crs.array}
\alias{.wgs84_to_xy.array}
\alias{.xy_to_wgs84.array}
\alias{.xy_to_rc.array}
\alias{.rc_to_xy.array}
\alias{.x_to_arr.array}
\alias{.arr_to_x.array}
\alias{.x_bbox.array}
\alias{.get_idx.array}
\alias{snic_backends}
\alias{.check_x}
\alias{.has_crs}
\alias{.wgs84_to_xy}
\alias{.xy_to_wgs84}
\alias{.xy_to_rc}
\alias{.rc_to_xy}
\alias{.x_to_arr}
\alias{.arr_to_x}
\alias{.x_bbox}
\alias{.get_idx}
\alias{.rc_to_wgs84}
\alias{.wgs84_to_rc}
\alias{.check_x.SpatRaster}
\alias{.has_crs.SpatRaster}
\alias{.wgs84_to_xy.SpatRaster}
\alias{.xy_to_wgs84.SpatRaster}
\alias{.xy_to_rc.SpatRaster}
\alias{.rc_to_xy.SpatRaster}
\alias{.x_to_arr.SpatRaster}
\alias{.arr_to_x.SpatRaster}
\alias{.x_bbox.SpatRaster}
\alias{.get_idx.SpatRaster}
\title{Backend abstraction layer for SNIC data structures}
\usage{
\method{.check_x}{array}(x, param_name = "x")

\method{.has_crs}{array}(x)

\method{.wgs84_to_xy}{array}(x, seeds_wgs84)

\method{.xy_to_wgs84}{array}(x, seeds_xy)

\method{.xy_to_rc}{array}(x, seeds_xy)

\method{.rc_to_xy}{array}(x, seeds_rc)

\method{.x_to_arr}{array}(x)

\method{.arr_to_x}{array}(x, arr, names = NULL)

\method{.x_bbox}{array}(x)

\method{.get_idx}{array}(x, idx)

.check_x(x, param_name = "x")

.has_crs(x)

.wgs84_to_xy(x, seeds_wgs84)

.xy_to_wgs84(x, seeds_xy)

.xy_to_rc(x, seeds_xy)

.rc_to_xy(x, seeds_rc)

.x_to_arr(x)

.arr_to_x(x, arr, names = NULL)

.x_bbox(x)

.get_idx(x, idx)

.rc_to_wgs84(x, seeds_rc)

.wgs84_to_rc(x, seeds_wgs84)

\method{.check_x}{SpatRaster}(x, param_name = "x")

\method{.has_crs}{SpatRaster}(x)

\method{.wgs84_to_xy}{SpatRaster}(x, seeds_wgs84)

\method{.xy_to_wgs84}{SpatRaster}(x, seeds_xy)

\method{.xy_to_rc}{SpatRaster}(x, seeds_xy)

\method{.rc_to_xy}{SpatRaster}(x, seeds_rc)

\method{.x_to_arr}{SpatRaster}(x)

\method{.arr_to_x}{SpatRaster}(x, arr, names = NULL)

\method{.x_bbox}{SpatRaster}(x)

\method{.get_idx}{SpatRaster}(x, idx)
}
\arguments{
\item{x}{Backend-specific raster/array object that implements these
conversions.}

\item{param_name}{Parameter name to echo in validation errors for
\code{.check_x()}.}

\item{seeds_wgs84}{Two-column seed object with columns \code{lat} and
\code{lon} (\code{EPSG:4326}).}

\item{seeds_xy}{Two-column seed object with columns \code{x} and \code{y}
expressed in the CRS of \code{x}.}

\item{seeds_rc}{Two-column seed object with 1-based pixel indices
\code{r} (row) and \code{c} (column).}

\item{arr}{Numeric array with dimensions \code{(height, width, bands)}.}

\item{names}{Optional character vector of band names applied by
\code{.arr_to_x()} when the target backend supports them.}

\item{idx}{Numeric or character band identifiers to resolve via
\code{.get_idx()}.}
}
\value{
Results depend on the generic:
\itemize{
  \item \code{.check_x()}: the validated backend object (usually \code{x})
  returned invisibly; errors if unsupported.
  \item \code{.has_crs()}: logical flag indicating whether \code{x} carries
  a CRS.
  \item \code{.wgs84_to_xy()}: seed data frame with columns \code{x} and
  \code{y} in the CRS of \code{x}.
  \item \code{.xy_to_wgs84()}: seed data frame with columns \code{lat} and
  \code{lon} in \code{EPSG:4326}.
  \item \code{.xy_to_rc()}: seed data frame with 1-based integer columns
  \code{r} and \code{c}; values outside the raster extent may be
  \code{NA_integer_}.
  \item \code{.rc_to_xy()}: seed data frame with columns \code{x} and
  \code{y} in the CRS of \code{x}, with coordinates set to \code{NA} when
  indices fall outside the extent.
  \item \code{.rc_to_wgs84()}: seed data frame with columns \code{lat} and
  \code{lon} obtained by composing \code{.rc_to_xy()} and
  \code{.xy_to_wgs84()}.
  \item \code{.wgs84_to_rc()}: seed data frame with columns \code{r} and
  \code{c} obtained by composing \code{.wgs84_to_xy()} and
  \code{.xy_to_rc()}.
  \item \code{.x_to_arr()}: numeric array shaped \code{(height, width,
  bands)} in column-major order.
  \item \code{.arr_to_x()}: object of the same backend type as \code{x}
  containing the supplied array data, with band names applied when
  provided.
  \item \code{.x_bbox()}: numeric vector \code{c(xmin, xmax, ymin, ymax)}
  in the coordinate system of \code{x}.
  \item \code{.get_idx()}: numeric vector of band indices resolved from
  numeric or name-based input.
}
}
\description{
These generics define the minimal interface required for SNIC to operate on
different raster / array backends. Implementations must convert between:
\itemize{
  \item geographic coordinates \code{(lat, lon)},
  \item projected map coordinates (\code{x, y}), and
  \item pixel indices (\code{r, c}) in image space,
}
and must provide functions to translate external image objects to raw
numeric arrays (and back) for input to the SNIC core.
}
\details{
The SNIC algorithm itself only works with:
\itemize{
  \item a numeric array \code{arr} with dimensions
     \code{(height, width, bands)}, and
  \item a two-column matrix/data frame \code{seeds_rc} giving pixel
     coordinates.
}
All spatial logic, projection handling, and raster I/O is delegated to these
interface methods.
}
\note{
Backends may differ dramatically in how they internally represent
coordinates and storage layouts. The only requirement is that these
methods form a consistent round-trip:
\code{
    lat/lon  <->  (x, y)  <->  (r, c)  <->  arr
}
}
\section{Required Methods for each backend}{

\itemize{
  \item \code{.check_x(x)}
  Validate that \code{x} is a supported input type. Return the validated
  object (usually \code{x}) invisibly if supported, or throw an error with a
  helpful message if not. This is the entry point for SNIC algorithm
  compatibility.

  \item \code{.has_crs(x)}
  Return \code{TRUE} if \code{x} carries a spatial reference system. Used
  to decide whether seeds are interpreted as pixel coordinates or
  \code{(lat, lon)}.

  \item \code{.wgs84_to_xy(x, seeds_wgs84)}
  Convert \code{(lat, lon)} coordinates in \code{EPSG:4326} to projected
  map coordinates of \code{x}'s CRS.

  \item \code{.xy_to_rc(x, seeds_xy)}
  Convert projected \code{(x, y)} (map) coordinates to image pixel indices
  \code{(r, c)}. Output must be integer and 1-based.

  \item \code{.rc_to_wgs84(x, seeds_rc)}
  Inverse of the above: convert 1-based pixel indices to \code{(lat, lon)}.
  Used to return seeds or segmentation results in geographic form.

  \item \code{.x_to_arr(x)}
  Convert image \code{x} to a numeric array of shape
  \code{(height, width, bands)} in column-major order. No normalization,
  scale adjustments, or band selection should be performed here.

  \item \code{.arr_to_x(x, arr, names = NULL)}
  Wrap a \code{(height, width, bands)} numeric array (often single-band
  output from SNIC) back into the native data type of \code{x}, preserving
  extent, CRS, resolution, and metadata where possible.

  \item \code{.xy_to_wgs84(x, seeds_xy)} and \code{.rc_to_xy(x, seeds_rc)}
  Inverse conversions that return geographic or projected map coordinates
  from the respective inputs.

  \item \code{.x_bbox(x)} Return \code{c(xmin, xmax, ymin, ymax)} in the
  CRS (or pixel) coordinate system of \code{x}.

  \item \code{.get_idx(x, idx)} Resolve character band names or numeric
  indices into explicit numeric positions for use in downstream helpers.
}
}

\keyword{internal}
