% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-spline.r
\name{smooth_spline}
\alias{smooth_spline}
\title{Spline interpolation}
\usage{
smooth_spline(x, wrap = TRUE, vertex_factor = 5, n)
}
\arguments{
\item{x}{numeric matrix; 2-column matrix of coordinates.}

\item{wrap}{logical; whether the coordinates should be wrapped at the ends,
as for polygons and closed lines.}

\item{vertex_factor}{double; the proportional increase in the number of
vertices in the smooth curve. For example, if the original curve has 100
points, a value of \code{2.5} will yield a new smoothed curve with 250 points.
Ignored if \code{n} is specified.}

\item{n}{integer; number of vertices in the smoothed curve.}
}
\value{
A matrix with the coordinates of the smoothed curve.
}
\description{
Spline interpolation uses \code{\link[stats:spline]{stats::spline()}} to interpolate between existing
vertices using piecewise cubic polynomials. The \code{x} and \code{y} coordinates are
interpolated independently. The feature curve will always pass through the
vertices of the original feature.
}
\details{
This function works on matrices of points and is generally not called
directly. Instead, use \code{\link[=smooth]{smooth()}} with \code{method = "spline"} to apply this
smoothing algorithm to spatial features.
}
\examples{
# smooth_spline works on matrices of coordinates
# use the matrix of coordinates defining a polygon as an example
m <- jagged_polygons$geometry[[2]][[1]]
m_smooth <- smooth_spline(m)
class(m)
class(m_smooth)
plot(m_smooth, type = "l", col = "red", axes = FALSE, xlab = NA, ylab = NA)
lines(m, col = "black")

# smooth is a wrapper for smooth_spline that works on spatial features
library(sf)
p <- jagged_polygons$geometry[[2]]
p_smooth <- smooth(p, method = "spline")
class(p)
class(p_smooth)
plot(p_smooth, border = "red")
plot(p, add = TRUE)
}
\references{
The spline method was inspired by the following StackExchange
posts:
\itemize{
\item \href{https://stackoverflow.com/questions/26087772/26089377}{Create polygon from set of points distributed}
\item \href{https://gis.stackexchange.com/questions/24827/24929}{Smoothing polygons in contour map?}
}
}
\seealso{
\code{\link[=smooth]{smooth()}}
}
