% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simgum.R
\name{sim.gum}
\alias{sim.gum}
\title{Simulate Generalised Exponential Smoothing}
\usage{
sim.gum(orders = c(1), lags = c(1), obs = 10, nsim = 1,
  frequency = 1, measurement = NULL, transition = NULL,
  persistence = NULL, initial = NULL, randomizer = c("rnorm", "rt",
  "rlaplace", "rs"), iprob = 1, ...)
}
\arguments{
\item{orders}{Order of the model. Specified as vector of number of states
with different lags. For example, \code{orders=c(1,1)} means that there are
two states: one of the first lag type, the second of the second type.}

\item{lags}{Defines lags for the corresponding orders. If, for example,
\code{orders=c(1,1)} and lags are defined as \code{lags=c(1,12)}, then the
model will have two states: the first will have lag 1 and the second will
have lag 12. The length of \code{lags} must correspond to the length of
\code{orders}.}

\item{obs}{Number of observations in each generated time series.}

\item{nsim}{Number of series to generate (number of simulations to do).}

\item{frequency}{Frequency of generated data. In cases of seasonal models
must be greater than 1.}

\item{measurement}{Measurement vector \eqn{w}. If \code{NULL}, then
estimated.}

\item{transition}{Transition matrix \eqn{F}. Can be provided as a vector.
Matrix will be formed using the default \code{matrix(transition,nc,nc)},
where \code{nc} is the number of components in state vector. If \code{NULL},
then estimated.}

\item{persistence}{Persistence vector \eqn{g}, containing smoothing
parameters. If \code{NULL}, then estimated.}

\item{initial}{Vector of initial values for state matrix. If \code{NULL},
then generated using advanced, sophisticated technique - uniform
distribution.}

\item{randomizer}{Type of random number generator function used for error
term. Defaults are: \code{rnorm}, \code{rt}, \code{rlaplace} and \code{rs}.
\code{rlnorm} should be used for multiplicative models (e.g. ETS(M,N,N)).
But any function from \link[stats]{Distributions} will do the trick if the
appropriate parameters are passed. For example \code{rpois} with
\code{lambda=2} can be used as well, but might result in weird values.}

\item{iprob}{Probability of occurrence, used for intermittent data
generation. This can be a vector, implying that probability varies in time
(in TSB or Croston style).}

\item{...}{Additional parameters passed to the chosen randomizer. All the
parameters should be passed in the order they are used in chosen randomizer.
For example, passing just \code{sd=0.5} to \code{rnorm} function will lead
to the call \code{rnorm(obs, mean=0.5, sd=1)}.}
}
\value{
List of the following values is returned:
\itemize{
\item \code{model} - Name of GUM model.
\item \code{measurement} - Matrix w.
\item \code{transition} - Matrix F.
\item \code{persistence} - Persistence vector. This is the place, where
smoothing parameters live.
\item \code{initial} - Initial values of GUM in a form of matrix. If \code{nsim>1},
then this is an array.
\item \code{data} - Time series vector (or matrix if \code{nsim>1}) of the generated
series.
\item \code{states} - Matrix (or array if \code{nsim>1}) of states. States are in
columns, time is in rows.
\item \code{residuals} - Error terms used in the simulation. Either vector or matrix,
depending on \code{nsim}.
\item \code{occurrence} - Values of occurrence variable. Once again, can be either
a vector or a matrix...
\item \code{logLik} - Log-likelihood of the constructed model.
}
}
\description{
Function generates data using GUM with Single Source of Error as a data
generating process.
}
\details{
For the information about the function, see the vignette:
\code{vignette("simulate","smooth")}
}
\examples{

# Create 120 observations from GUM(1[1]). Generate 100 time series of this kind.
x <- sim.gum(orders=c(1),lags=c(1),obs=120,nsim=100)

# Generate similar thing for seasonal series of GUM(1[1],1[4]])
x <- sim.gum(orders=c(1,1),lags=c(1,4),frequency=4,obs=80,nsim=100,transition=c(1,0,0.9,0.9))

# Estimate model and then generate 10 time series from it
ourModel <- gum(rnorm(100,100,5))
simulate(ourModel,nsim=10)

}
\references{
\itemize{
\item Svetunkov I. (2015 - Inf) "smooth" package for R - series of posts about the underlying
models and how to use them: \url{https://forecasting.svetunkov.ru/en/tag/smooth/}.
\item Svetunkov I. (2017). Statistical models underlying functions of 'smooth'
package for R. Working Paper of Department of Management Science, Lancaster
University 2017:1, 1-52.
}
}
\seealso{
\code{\link[smooth]{sim.es}, \link[smooth]{sim.ssarima},
\link[smooth]{sim.ces}, \link[smooth]{gum}, \link[stats]{Distributions}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
