% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viss.R
\name{viss}
\alias{viss}
\title{Vector Intermittent State Space}
\usage{
viss(data, intermittent = c("logistic", "none", "fixed"), ic = c("AICc",
  "AIC", "BIC"), h = 10, holdout = FALSE, probability = c("dependent",
  "independent"), model = "ANN", persistence = NULL, transition = NULL,
  phi = NULL, initial = NULL, initialSeason = NULL, xreg = NULL)
}
\arguments{
\item{data}{The matrix with data, where series are in columns and
observations are in rows.}

\item{intermittent}{Type of method used in probability estimation. Can be
\code{"none"} - none, \code{"fixed"} - constant probability or
\code{"logistic"} - probability based on logit model.}

\item{ic}{Information criteria to use in case of model selection.}

\item{h}{Forecast horizon.}

\item{holdout}{If \code{TRUE}, holdout sample of size \code{h} is taken from
the end of the data.}

\item{probability}{Type of probability assumed in the model. If
\code{"dependent"}, then it is assumed that occurrence of one variable is
connected with the occurrence with another one. In case of \code{"independent"}
the occurrence of the variables is assumed to happen independ of each
other.}

\item{model}{Type of ETS model used for the estimation. Normally this should
be either \code{"ANN"} or \code{"MNN"}. If you assume that there are some
tendencies in occurrence, then you can use more complicated models. Model
selection is not yet available.}

\item{persistence}{Persistence matrix type. If \code{NULL}, then it is estimated.
See \link[smooth]{ves} for the details.}

\item{transition}{Transition matrix type. If \code{NULL}, then it is estimated.
See \link[smooth]{ves} for the details.}

\item{phi}{Damping parameter type. If \code{NULL}, then it is estimated.
See \link[smooth]{ves} for the details.}

\item{initial}{Initial vector type. If \code{NULL}, then it is estimated.
See \link[smooth]{ves} for the details.}

\item{initialSeason}{Type of the initial vector of seasonal components.
If \code{NULL}, then it is estimated. See \link[smooth]{ves} for the details.}

\item{xreg}{Vector of matrix of exogenous variables, explaining some parts
of occurrence variable (probability).}
}
\value{
The object of class "iss" is returned. It contains following list of
values:

\itemize{
\item \code{model} - the type of the estimated ETS model;
\item \code{fitted} - fitted values of the constructed model;
\item \code{forecast} - forecast for \code{h} observations ahead;
\item \code{states} - values of states (currently level only);
\item \code{variance} - conditional variance of the forecast;
\item \code{logLik} - likelihood value for the model
\item \code{nParam} - number of parameters used in the model;
\item \code{residuals} - residuals of the model;
\item \code{actuals} - actual values of probabilities (zeros and ones).
\item \code{persistence} - the vector of smoothing parameters;
\item \code{initial} - initial values of the state vector;
\item \code{initialSeason} - the matrix of initials seasonal states;
\item \code{intermittent} - type of intermittent model used;
\item \code{probability} - type of probability used;
\item \code{issModel} - intermittent state-space model used for
calculations. Useful only in the case of \code{intermittent="l"} and
\code{probability="d"}.
}
}
\description{
Function calculates the probability for vector intermittent state space model.
This is needed in order to forecast intermittent demand using other functions.
}
\details{
The function estimates probability of demand occurrence, using one of the VES
state-space models.
}
\examples{

    Y <- cbind(c(rpois(25,0.1),rpois(25,0.5),rpois(25,1),rpois(25,5)),
               c(rpois(25,0.1),rpois(25,0.5),rpois(25,1),rpois(25,5)))

    viss(Y, intermittent="l")
    viss(Y, intermittent="l", probability="i")

}
\references{
\itemize{
\item Svetunkov Ivan and Boylan John E. (2017). Multiplicative
State-Space Models for Intermittent Time Series. Working Paper of
Department of Management Science, Lancaster University, 2017:4 , 1-43.
\item Teunter R., Syntetos A., Babai Z. (2011). Intermittent demand:
Linking forecasting to inventory obsolescence. European Journal of
Operational Research, 214, 606-615.
\item Croston, J. (1972) Forecasting and stock control for intermittent
demands. Operational Research Quarterly, 23(3), 289-303.
\item Syntetos, A., Boylan J. (2005) The accuracy of intermittent demand
estimates. International Journal of Forecasting, 21(2), 303-314.
}
}
\seealso{
\code{\link[forecast]{ets}, \link[forecast]{forecast},
\link[smooth]{es}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{demand}
\keyword{exponential}
\keyword{forecasting}
\keyword{intermittent}
\keyword{iss}
\keyword{model}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{smoothing}
\keyword{space}
\keyword{state}
\keyword{ts}
\keyword{univar}
