% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mof.dtlz1.R
\name{makeDTLZ1Function}
\alias{makeDTLZ1Function}
\title{DTLZ1 Function (family)}
\usage{
makeDTLZ1Function(dimensions, n.objectives)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the multi-objective DTLZ1 test problem.
}
\details{
The DTLZ1 test problem is defined as follows:

Minimize \eqn{f_1(\mathbf{x}) = \frac{1}{2} x_1 x_2 \cdots x_{M-1} (1+g(\mathbf{x}_M),}{
f[1](X) = 1/2 * x[1] * x[2] * ... * x[M-1] * (1 + g(XM))}

Minimize \eqn{f_2(\mathbf{x}) = \frac{1}{2} x_1 x_2 \cdots (1-x_{M-1}) (1+g(\mathbf{x}_M)),}{
f[2](X) = 1/2 * x[1] * x[2] * ... * (1 - x[M-1]) * (1 + g(XM))}

\eqn{\vdots\\}{...}

Minimize \eqn{f_{M-1}(\mathbf{x}) = \frac{1}{2} x_1 (1-x_2) (1+g(\mathbf{x}_M)),}{
f[M-1](X) = 1/2 * x[1] * (1 - x[2]) * (1 + g(XM))}

Minimize \eqn{f_{M}(\mathbf{x}) = \frac{1}{2} (1-x_1) (1+g(\mathbf{x}_M)),}{
f[M](X) = 1/2 * (1 - x[1]) * (1 + g(XM))}

with \eqn{0 \leq x_i \leq 1}{0 <= x[i] <= 1}, for \eqn{i=1,2,\dots,n,}{i=1,2,...,n}

where \eqn{g(\mathbf{x}_M) = 100 \left[|\mathbf{x}_M| + \sum\limits_{x_i \in \mathbf{x}_M} (x_i - 0.5)^2 - \cos(20\pi(x_i - 0.5))\right]}{
g(XM) = 100 * (|XM| + sum{x[i] in XM} {(x[i] - 0.5)^2 - cos(20 * pi * (x[i] - 0.5))})}
}
\references{
K. Deb and L. Thiele and M. Laumanns and E. Zitzler. Scalable
Multi-Objective Optimization Test Problems. Computer Engineering and Networks
Laboratory (TIK), Swiss Federal Institute of Technology (ETH) Zurich, 112, 2001
}

