% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mof.zdt6.R
\name{makeZDT6Function}
\alias{makeZDT6Function}
\title{ZDT6 Function}
\usage{
makeZDT6Function(dimensions)
}
\arguments{
\item{dimensions}{[\code{integer(1)}]\cr
Number of decision variables.}
}
\value{
[\code{smoof_multi_objective_function}]
}
\description{
Builds and returns the two-objective ZDT6 test problem. For \eqn{m} objective it
is defined as follows
\deqn{f(\mathbf{x}) = \left(f_1(\mathbf{x}), f_2(\mathbf{x})\right)}
with
\deqn{f_1(\mathbf{x}) = 1 - \exp(-4\mathbf{x}_1)\sin^6(6\pi\mathbf{x}_1), f_2(\mathbf{x}) = g(\mathbf{x}) h(f_1(\mathbf{x}_1), g(\mathbf{x}))}
where
\deqn{g(\mathbf{x}) = 1 + 9 \left(\frac{\sum_{i = 2}^{m}\mathbf{x}_i}{m - 1}\right)^{0.25}, h(f_1, g) = 1 - \left(\frac{f_1(\mathbf{x})}{g(\mathbf{x})}\right)^2}
and \eqn{\mathbf{x}_i \in [0,1], i = 1, \ldots, m}.
This function introduced two difficulities (see reference):
1. the density of solutions decreases with the closeness to the Pareto-optimal front and
2. the Pareto-optimal solutions are nonuniformly distributed along the front.
}
\references{
E. Zitzler, K. Deb, and L. Thiele. Comparison of Multiobjective
Evolutionary Algorithms: Empirical Results. Evolutionary Computation, 8(2):173-195, 2000
}

