% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cardinalBasis_natSpline}
\alias{cardinalBasis_natSpline}
\title{Cardinal Basis for natural cubic spline interpolation}
\usage{
cardinalBasis_natSpline(x, xout, deriv = 0)
}
\arguments{
\item{x}{Numeric vector of design points.}

\item{xout}{Numeric vector of new points.}

\item{deriv}{Integer. Order of derivation. Can be \code{0}, \code{1}
or \code{2}.}
}
\value{
A list with several elements

\item{x}{

Numeric vector of abscissas at which the basis is evaluated. This
is a copy of \code{xout}.

}
\item{CB}{

Matrix of the Cardinal Basis function values.

}
\item{deriv}{

Order of derivation as given on input.

}
\item{method}{

Character description of the method involved in the CB determination.

}
}
\description{
Cardinal Basis for natural cubic spline interpolation.
}
\details{
This is a simple and raw interface to \code{splinterp} Fortran
subroutine.
}
\examples{
set.seed(123)
n <- 16; nout <- 360
x <- sort(runif(n))

##' ## let 'xout' contain n + nout points including nodes
xout <- sort(c(x, seq(from =  x[1] + 1e-8, to = x[n] - 1e-8, length.out = nout)))
res  <- cardinalBasis_natSpline(x, xout = xout)

matplot(res$x, res$CB, type = "n", main = "Cardinal Basis")
abline(v = x, h = 1.0, col = "gray")
points(x = x, y = rep(0, n), pch = 21, col = "black", lwd = 2, bg = "white")
matlines(res$x, res$CB, type = "l")

## compare with 'splines'
require(splines)
y <- sin(2* pi * x)
sp <- interpSpline(x, y)
test <- rep(NA, 3)
der <- 0:2
names(test) <- nms <- paste("deriv. ", der, sep = "")
for (i in seq(along = der)) {
   resDer <- cardinalBasis_natSpline(x, xout = xout, deriv = der[i])
   test[nms[i]] = max(abs(predict(sp, xout, deriv = der[i])$y - resDer$CB \\\%*\\\% y))
}
test
## Lebesgue's function
plot(x = xout, y = apply(res$CB, 1, function(x) sum(abs(x))), type = "l",
     lwd = 2, col = "orangered", main = "Lebesgue\\'s function", log = "y",
     xlab = "x", ylab = "L(x)")
points(x = x, y = rep(1, n), pch = 21, col = "black", lwd = 2, bg = "white")
}
\author{
Yves Deville
}

