% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{single_pexp}
\alias{single_pexp}
\title{Powered Exponential covariance function (scalar)}
\usage{
single_pexp(d, sigsq, phi, nu)
}
\arguments{
\item{d}{a scalar representing the distance on which it is desired to
evaluate the covariance function.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Exponential covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Exponential covariance function,
controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu \in (0, 2]} parameter representing the "power"}
}
\value{
a scalar representing the (exponential) covariance between two
observations \code{d} apart of each other.
}
\description{
Computing the Powered Exponential covariance function for a
single distance measure.
}
\seealso{
\code{\link{single_exp}}, \code{\link{single_matern}},
\code{\link{single_matern3}}, \code{\link{single_matern5}},
\code{\link{mat_cov}}
}
\keyword{internal}
