% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{comp_mat_cov}
\alias{comp_mat_cov}
\title{Matern covariance function for a polygons.}
\usage{
comp_mat_cov(cross_dists, n, n2, sigsq, phi, nu)
}
\arguments{
\item{cross_dists}{a \code{list} such that each position contains the cross
distances between points within different polygons.}

\item{n}{an ingeger representing number of polygons (note that, this is
different than the size of the list \code{cross_dists}}

\item{n2}{usually, equal to \code{n}, except when the function is being used
to calculate the "cross" covariance between two different partitions of
the same space.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,
controls the range of the spatial dependence.}

\item{nu}{the \eqn{\nu} parameter from the Matern covariance function,
controls the differentiability of the process. Note that, if we set
\code{nu = .5}, then the calculations are based on the exponential
covariance function.}
}
\value{
The matern covariance matrix associated with a set of polygons.
}
\description{
Computing the Matern covariance function between polygons.
}
\seealso{
\code{\link{single_exp}}, \code{\link{single_matern}},
\code{\link{mat_cov}}
}
\keyword{internal}
