% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_stat.R
\name{scan_stat}
\alias{scan_stat}
\alias{stat_poisson}
\alias{stat_binom}
\title{Spatial scan statistic}
\usage{
scan_stat(
  yin,
  ein = NULL,
  eout = NULL,
  ty,
  type = "poisson",
  popin = NULL,
  tpop = NULL,
  a = 0,
  shape = 1,
  yout = NULL,
  popout = NULL
)

stat_poisson(yin, yout, ein, eout, a = 0, shape = 1)

stat_binom(yin, yout, ty, popin, popout, tpop)
}
\arguments{
\item{yin}{The total number of cases in the zone.}

\item{ein}{The expected number of cases in the zone.
Conventionally, this is the estimated overall disease
risk across the study area, multiplied by the total
population size of the zone.}

\item{eout}{The expected number of cases outside the
zone.  This should be \code{ty - ein} and is computed
automatically if not provided.}

\item{ty}{The total number of cases in the study area.}

\item{type}{The type of scan statistic to implement. The
default choice are \code{"poisson"}.  The other choice
is \code{"binomial"}.}

\item{popin}{The total population in the zone.}

\item{tpop}{The total population in the study area.}

\item{a}{A tuning parameter for the adjusted
log-likelihood ratio.  See details.}

\item{shape}{The shape of the ellipse, which is the ratio
of the length of the longest and shortest axes of the
ellipse.  The default is 1, meaning it is a circle.}

\item{yout}{The observed number of cases outside the
zone.  This should be \code{ty - yin} and is computed
automatically if not provided.}

\item{popout}{The population outside the zone.  This
should be \code{tpop - popin} and is computed
automatically if not provided.}
}
\value{
A vector of scan statistics.
}
\description{
\code{scan_stat} calculates the spatial scan statistic
for a zone (a set of spatial regions).  The statistic is
the log of the likelihood ratio test statistic of the
chosen distribution.  If \code{type = "poisson"} and
\code{a} is more than zero, this statistic is penalized.
See references.
}
\examples{
# New York leukemia data
# total cases
ty <- 552
# total population
tpop <- 1057673

# poisson example with yin = 106 and ein = 62.13
scan_stat(yin = 106, ty = ty, ein = 62.13)
stat_poisson(
  yin = 106, yout = 552 - 106,
  ein = 62.13, eout = 552 - 62.13
)

# binomial example with yin = 41 and popin = 38999
scan_stat(
  yin = 41, ty = ty,
  popin = 38999, tpop = tpop, type = "binomial"
)
stat_binom(41, ty - 41, ty, 38999, tpop - 38999, tpop)
}
\references{
Poisson scan statistic:  Kulldorff, M. (1997) A spatial
scan statistic. Communications in Statistics - Theory and
Methods, 26(6): 1481-1496,
<doi:10.1080/03610929708831995>

Penalized Poisson scan statistic: Kulldorff, M., Huang,
L., Pickle, L. and Duczmal, L. (2006) An elliptic spatial
scan statistic. Statistics in Medicine, 25:3929-3943.
<doi:10.1002/sim.2490>

Binomial scan statistic: Duczmal, L. and Assuncao, R.
(2004) A simulated annealing strategy for the detection
of arbitrarily shaped spatial clusters. Computational
Statistics & Data Analysis, 45(2):269-286.
<doi:10.1016/S0167-9473(02)00302-X>
}
\author{
Joshua French
}
