% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smbinning.R
\name{smbinning.factor}
\alias{smbinning.factor}
\title{Binning on Factor Variables}
\usage{
smbinning.factor(df, y, x, maxcat = 10)
}
\arguments{
\item{df}{A data frame.}

\item{y}{Binary response variable (0,1). Integer (\code{int}) is required.
Name of \code{y} must not have a dot.}

\item{x}{A factor variable with at least 2 different values. Value \code{Inf} is not allowed.}

\item{maxcat}{Specifies the maximum number of categories.  Default value is 10.
Name of \code{x} must not have a dot.}
}
\value{
The command \code{smbinning.factor} generates and object containing the necessary info and utilities for binning.
The user should save the output result so it can be used 
with \code{smbinning.plot}, \code{smbinning.sql}, and \code{smbinning.gen.factor}.
}
\description{
It generates a table with relevant metrics for all the categories of a given factor variable.
}
\examples{
# Training and testing samples (Just some basic formality for Modeling)
pop=chileancredit # Set population
train=subset(pop,Rnd<=0.7) # Training sample
test=subset(pop,Rnd>0.7) # Testing sample
rm(chileancredit) # Remove original dataset

# Binning a factor variable
result=smbinning.factor(train,x="CuWealth",y="FlagGB",maxcat=11)
result$ivtable
result$iv
}
