% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instanceSelection.R
\name{instance_selection}
\alias{instance_selection}
\title{Instance selection wrapper}
\usage{
instance_selection(dataset, method, class_attr = "Class", ...)
}
\arguments{
\item{dataset}{we want to perform an instance selection on}

\item{method}{selected method of instance selection}

\item{class_attr}{\code{character}. Indicates the class attribute from
\code{dataset}. Must exist in it}

\item{...}{Further arguments for \code{method}}
}
\value{
A filtered dataset with same shape as the input to the function
}
\description{
Instance selection wrapper
}
\examples{
library("smartdata")

super_iris <- instance_selection(iris, method = "CNN", class_attr = "Species")
# Use k = 2 instead of default k
super_iris <- instance_selection(iris, method = "CNN", class_attr = "Species", k = 2)
# Use Edited Nearest Neighbor as method to select observations
super_iris <- instance_selection(iris, method = "ENN", class_attr = "Species", k = 3)
super_iris <- instance_selection(iris, method = "multiedit", class_attr = "Species",
                   k = 3, num_folds = 5, null_passes = 8)
# Use default arguments for multiedit
super_iris <- instance_selection(iris, method = "multiedit", class_attr = "Species")
super_iris <- instance_selection(iris, method = "FRIS", class_attr = "Species")
# FRIS method with fuzzy granularity of 2
super_iris <- instance_selection(iris, method = "FRIS", class_attr = "Species", alpha = 2)
# FRIS method with Dubois Prade implicator
super_iris <- instance_selection(iris, method = "FRIS", "Species", implicator_type = "dubois_prade")
# FRIS method with lower threshold (that is, less observations are removed)
super_iris <- instance_selection(iris, method = "FRIS", class_attr = "Species", threshold = 0.6)

}
