% Generated by roxygen2 (4.0.2): do not edit by hand
\name{confenv}
\alias{confenv}
\alias{confenv.kdenv}
\title{Confidence envelopes for difference in estimated K functions}
\usage{
confenv(object, level)

\method{confenv}{kdenv}(object, level = 0.95)
}
\arguments{
\item{object}{A \code{kdenv} object from the \code{kd.env} function.}

\item{level}{Confidence level.  Should be a number between 0 and 1.}
}
\value{
Returns an \code{confenvkd} object.  This is just a data frame with \code{r}, the distances at which the confidence envelope is calculated, \code{lo}, the lower bounds of the confidence envelopes, and \code{hi}, the upper bounds of the confidence envelopes.
}
\description{
\code{confenv} determines confidence envelopes for the difference in estimated K functions for a set of cases and controls using a \code{kdenv} object.
}
\examples{
data(grave)
env = kd.env(grave, nsim = 19)
ci = confenv(env, level = 0.9)
plot(env, legend = FALSE)
}
\author{
Joshua French
}
\references{
Waller, L.A. and Gotway, C.A. (2005).  Applied Spatial Statistics for Public Health Data.  Hoboken, NJ: Wiley.
}

