\name{Predict.matrix.slp.smooth}
\alias{Predict.matrix.slp.smooth}
\alias{slp.smooth}
\title{Create model matrix for prediction, for model using slp smoother}
\description{
  Re-generate the basis matrix for a particular \code{N, W} Slepian sequence
  family member, with the additional property that the smoother captures/passes constants
  without distortion. Simply re-arranges \code{object}. Not intended to be used
  directly by user. 
}
\usage{
\method{Predict.matrix}{slp.smooth}(object,data)
}
\arguments{
  \item{object}{a smooth specification object, usually generated by a model term \code{s(..., bs = 'slp', ..., xt = list(...))},
       and for this type, \bold{requiring} an additional \code{xt = list()} object containing parameters.
       For examples, see below. }
  \item{data}{a list containing just the data required by this term, with names corresponding to
       \code{object[['term']]}. Typically just a single time index array.}
}
\value{
    A corrected (re-assembled) version of \code{object}, which contains the 
    \code{X} basis vectors in a format that can be used by \code{predict} or
    \code{plot}. 
}
\details{
    Presumably because most basis sets are larger in size than their computational
    burden, \code{mgcv} passes objects around without including the actual basis
    vectors. For example, if using basis \code{cr}, the parameters are included in
    \code{object}, and then the bases re-computed as needed.

    As the \code{slp} basis is significantly more computational in nature, the
    basis vectors are saved as part of the object. While \code{mgcv} deletes
    the main set of time-aligned vectors, this routine restores such vectors
    so that \code{predict} and \code{plot} work correctly. 
}
\seealso{
  \code{\link[mgcv]{smooth.construct}},
  \code{\link[mgcv]{Predict.matrix}}
}
