% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slippymath.R
\name{bbox_tile_query}
\alias{bbox_tile_query}
\title{bbox_tile_query}
\usage{
bbox_tile_query(bbox, zoom_levels = 2:18)
}
\arguments{
\item{bbox}{a bbox object created by `sf::st_bbox`, or a vector with names
'xmin', 'xmax', 'ymin', 'ymax'}

\item{zoom_levels}{a numeric vector of zoom levels to calculate tile usage for.}
}
\value{
a data frame containing tile usage information for the bounding box
  at each zoom level.
}
\description{
Bounding box tile query
}
\details{
Determines how many tiles the bounding box would occupy for a range of zooms. Useful for working out what is a reasonable zoom to work at. Each tile is a separate request from the server.

Tiles are typically 256x256 pixels and are tens of Kb in size, you can get some sense of the data from the query also.
}
\examples{
tibrogargan<- c(xmin = 152.938485, ymin = -26.93345, xmax = 152.956467, 
               ymax = -26.921463)

bbox_tile_query(tibrogargan)
}
