% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/slfm.r
\name{slfm}
\alias{slfm}
\title{Sparse Latent Factor Model}
\usage{
slfm(x, a = 2.1, b = 1.1, gamma_a = 1, gamma_b = 1, omega_0 = 0.01,
  omega_1 = 10, sample = 1000, burnin = round(0.25 * sample), lag = 1,
  degenerate = FALSE)
}
\arguments{
\item{x}{matrix with the pre-processed data}

\item{a}{prior shape parameter for Gamma distribution}

\item{b}{prior scale parameter for Gamma distribution}

\item{gamma_a}{prior parameter for Beta distribution}

\item{gamma_b}{prior parameter for Beta distribution}

\item{omega_0}{prior variance of the spike component}

\item{omega_1}{prior variance of the slab component}

\item{sample}{sample size after burn-in}

\item{burnin}{burn-in size}

\item{lag}{lag for MCMC}

\item{degenerate}{use the degenerate version of mixture}
}
\value{
x: data matrix

q_star: matrix of MCMC chains for q_star parameter

alpha: summary table of MCMC chains for alpha parameter

lambda: summary table of MCMC chains for lambda parameter

sigma: summary table of MCMC chains for sigma parameter

classification: classification of each alpha (`present`, `marginal`, `absent`)
}
\description{
This function is used to fit a Bayesian sparse
latent factor model.
}
\examples{
mat <- matrix(rnorm(2000), nrow = 20)
slfm(mat, sample = 1000)
}
\references{
1. Duarte, J. D. N. and Mayrink, V. D. (2015). Factor analysis with mixture modeling to evaluate coherent patterns in microarray data. In Interdisciplinary Bayesian Statistics, volume 118 of Springer Proceedings in Mathematics & Statistics, pages 185-195. Springer International Publishing.
}

