% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyglmnb.R
\name{svyglm.nb}
\alias{svyglm.nb}
\title{Survey-weighted negative binomial generalised linear model}
\usage{
svyglm.nb(formula, design, ...)
}
\arguments{
\item{formula}{An object of class \code{formula}, i.e. a symbolic description
of the model to be fitted. See 'Details' in \code{\link[stats]{glm}}.}

\item{design}{An object of class \code{\link[survey]{svydesign}}, providing
a specification of the survey design.}

\item{...}{Other arguments passed down to \code{\link[MASS]{glm.nb}}.}
}
\value{
A \code{\link[survey]{svymle}}-object.
}
\description{
\code{svyglm.nb()} is an extension to the \CRANpkg{survey}-package
               to fit survey-weighted negative binomial models. It uses
               \code{\link[survey]{svymle}} to fit sampling-weighted
               maximum likelihood estimates, based on starting values provided
               by \code{\link[MASS]{glm.nb}}, as proposed by \emph{Lumley
               (2010, pp249)}.
}
\details{
For details on the computation method, see Lumley (2010), Appendix E
         (especially 254ff.)
}
\examples{
# ------------------------------------------
# This example reproduces the results from
# Lumley 2010, figure E.7 (Appendix E, p256)
# ------------------------------------------
library(survey)
data(nhanes_sample)

# create survey design
des <- svydesign(
  id = ~ SDMVPSU,
  strat = ~ SDMVSTRA,
  weights = ~ WTINT2YR,
  nest = TRUE,
  data = nhanes_sample
)

# fit negative binomial regression
fit <- svyglm.nb(total ~ factor(RIAGENDR) * (log(age) + factor(RIDRETH1)), des)

# print coefficients and standard errors
round(cbind(coef(fit), survey::SE(fit)), 2)

}
\references{
Lumley T (2010). Complex Surveys: a guide to analysis using R. Wiley
}
