% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_spss}
\alias{read_spss}
\title{Import SPSS dataset as data frame into R}
\usage{
read_spss(path, atomic.to.fac = FALSE, tag.na = FALSE)
}
\arguments{
\item{path}{File path to the data file.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, categorical variables imported
from the dataset (which are imported as \code{\link{atomic}}) will be
converted to factors.}

\item{tag.na}{Logical, if \code{TRUE}, missing values are imported
as \code{\link[haven]{tagged_na}} values; else, missing values are
converted to regular \code{NA} (default behaviour).}
}
\value{
A data frame containing the SPSS data. Retrieve value labels with
  \code{\link{get_labels}} and variable labels with \code{\link{get_label}}.
}
\description{
Import data from SPSS, including NA's, value and variable
  labels.
}
\details{
The \code{atomic.to.fac} option only
  converts those variables into factors that are of class \code{atomic} and
  which have value labels after import. Atomic vectors without value labels
  are considered as continuous and not converted to factors.
}
\note{
This is a wrapper function for \code{\link[haven]{read_spss}} of the
  \pkg{haven} package. This function adds value and variable labels as
  attributes to the imported variables of the data frame. \cr \cr Most
  functions of the \pkg{sjPlot} package access value and variable label
  attributes to automatically detect labels in order to set them as axis,
  legend or title labels in plots (\code{sjp.}-functions) respectively as
  column or row headers in table outputs (\code{sjt.}-functions).  See
  \href{http://www.strengejacke.de/sjPlot/datainit/}{online manual} for more
  details. \cr \cr When working with labelled data, you can, e.g., use
  \code{\link{get_label}} or \code{\link{get_labels}} to get a vector of
  value and variable labels, which can then be used with other functions like
  \code{\link{barplot}} etc. See 'Examples' from \code{\link{get_labels}}.
}
\examples{
\dontrun{
# import SPSS data set. uses haven's read function
mydat <- read_spss("my_spss_data.sav")

# use haven's read function, convert atomic to factor
mydat <- read_spss("my_spss_data.sav", atomic.to.fac = TRUE)

# retrieve variable labels
mydat.var <- get_label(mydat)

# retrieve value labels
mydat.val <- get_labels(mydat)}

}
\seealso{
\itemize{
 \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
 \item \href{http://www.strengejacke.de/sjPlot/labelleddata/}{sjPlot-manual: working with labelled data}
 \item \href{http://www.strengejacke.de/sjPlot/view_spss/}{sjPlot manual: inspecting (SPSS imported) data frames}
 \item \code{\link{write_spss}}
 }
}

