% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_na.R
\name{get_na}
\alias{get_na}
\title{Retrieve tagged NA values of labelled variables}
\usage{
get_na(x, as.tag = FALSE)
}
\arguments{
\item{x}{Variable (vector) with value label attributes, including
tagged missing values (see \code{\link[haven]{tagged_na}});
or a data frame or list with such variables.}

\item{as.tag}{Logical, if \code{TRUE}, the returned values are not tagged NA's,
but their string representative including the tag value. See 'Examples'.}
}
\value{
The tagged missing values and their associated value labels from \code{x},
          or \code{NULL} if \code{x} has no tagged missing values.
}
\description{
This function retrieves tagged NA values and their associated
               value labels from a labelled vector.
}
\details{
Other statistical software packages (like 'SPSS' or 'SAS') allow to define
           multiple missing values, e.g. \emph{not applicable}, \emph{refused answer}
           or "real" missing. These missing types may be assigned with
           different values, so it is possible to distinguish between these
           missing types. In R, multiple declared missings cannot be represented
           in a similar way with the regular missing values. However,
           \code{\link[haven]{tagged_na}} values can do this.
           Tagged \code{NA}s work exactly like regular R missing values
           except that they store one additional byte of information: a tag,
           which is usually a letter ("a" to "z") or character number ("0" to "9").
           This allows to indicate different missings.
           \cr \cr
           Furthermore, see 'Details' in \code{\link{get_values}}.
}
\examples{
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
x
get_na(x)
# which NA has which tag?
get_na(x, as.tag = TRUE)

# replace only the NA, which is tagged as NA(c)
replace_na(x, 2, tagged.na = "c")
get_na(replace_na(x, 2, tagged.na = "c"))

# data frame as input
y <- labelled(c(2:3, 3:1, tagged_na("y"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "Why" = tagged_na("y")))
get_na(data.frame(x, y))


}
\seealso{
\code{\link{get_labels}} to get value labels, or \code{\link{get_values}}
           to get values associated with labels; see \code{\link{set_na}} to
           replace specific values with \code{NA}.
}

