% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_labels.R
\name{drop_labels}
\alias{drop_labels}
\title{Drop labels of zero-count values}
\usage{
drop_labels(x)
}
\arguments{
\item{x}{Variable (vector), \code{data.frame} or \code{list} of variables
with partially added value labels (see \code{\link[haven]{labelled}}).}
}
\value{
\code{x}, where labels for non-labelled values are added
}
\description{
This function drops all value labels for those values that have
               no cases (frequencies) in a vector.
}
\examples{
rp <- rec_pattern(1, 100)
rp

# sample data
data(efc)
# recode carers age into groups of width 5
x <- rec(efc$c160age, rp$pattern)
# add value labels to new vector
set_labels(x) <- rp$labels
# watch result. due to recode-pattern, we have age groups with
# no observations (zero-counts)
frq(as_labelled(x))

# now, let's drop zero's
frq(as_labelled(drop_labels(x)))

}
\seealso{
\code{\link{zap_labels}} and \code{\link{zap_unlabelled}} to convert
           (non-)labelled values into \code{NA}; \code{\link{fill_labels}} to
           add labels to existing, but not yet labelled values.
}

