% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjTabStackFrq.R
\name{sjt.stackfrq}
\alias{sjt.stackfrq}
\title{Summary of stacked frequencies as HTML table}
\usage{
sjt.stackfrq(items, weight.by = NULL, title = NULL, var.labels = NULL,
  value.labels = NULL, wrap.labels = 20, sort.frq = NULL,
  altr.row.col = FALSE, digits = 2, string.total = "N",
  string.na = "NA", show.n = FALSE, show.total = FALSE, show.na = FALSE,
  show.skew = FALSE, show.kurtosis = FALSE, digits.stats = 2,
  file = NULL, encoding = NULL, CSS = NULL, use.viewer = TRUE,
  no.output = FALSE, remove.spaces = TRUE)
}
\arguments{
\item{items}{Data frame, with each column representing one item.}

\item{weight.by}{Vector of weights that will be applied to weight all cases.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{title}{Table caption, as character vector.}

\item{var.labels}{Character vector with variable names, which will be used
to label variables in the output.}

\item{value.labels}{Character vector (or \code{list} of character vectors)
with value labels of the supplied variables, which will be used
to label variable values in the output.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis
labels are displayed in one line and when a line break is inserted.}

\item{sort.frq}{logical, indicates whether the \code{items} should be ordered by
by highest count of first or last category of \code{items}.
\itemize{
  \item Use \code{"first.asc"} to order ascending by lowest count of first category,
  \item \code{"first.desc"} to order descending by lowest count of first category,
  \item \code{"last.asc"} to order ascending by lowest count of last category,
  \item \code{"last.desc"} to order descending by lowest count of last category,
  \item or \code{NULL} (default) for no sorting.
}}

\item{altr.row.col}{Logical, if \code{TRUE}, alternating rows are highlighted with a light gray
background color.}

\item{digits}{Numeric, amount of digits after decimal point when rounding estimates and values.}

\item{string.total}{label for the total N column.}

\item{string.na}{label for the missing column/row.}

\item{show.n}{logical, if \code{TRUE}, adds total number of cases for each
group or category to the labels.}

\item{show.total}{logical, if \code{TRUE}, an additional column with each
item's total N is printed.}

\item{show.na}{logical, if \code{TRUE}, \code{\link{NA}}'s (missing values)
are added to the output.}

\item{show.skew}{logical, if \code{TRUE}, an additional column with each item's skewness is printed.
The skewness is retrieved from the \code{\link[psych]{describe}}-function
of the \pkg{psych}-package.}

\item{show.kurtosis}{Logical, if \code{TRUE}, the variable's kurtosis is added to the summary.
The kurtosis is retrieved from the \code{\link[psych]{describe}}-function
of the \pkg{psych}-package and indicated by a lower case Greek omega.}

\item{digits.stats}{amount of digits for rounding the skewness and kurtosis valuess.
Default is 2, i.e. skewness and kurtosis values have 2 digits after decimal point.}

\item{file}{Destination file, if the output should be saved as file.
If \code{NULL} (default), the output will be saved as temporary file and
openend either in the IDE's viewer pane or the default web browser.}

\item{encoding}{String, indicating the charset encoding used for variable and
value labels. Default is \code{NULL}, so encoding will be auto-detected
depending on your platform (e.g., \code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g. German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. For more details,
see \href{../doc/sjtbasic.html}{this package-vignette}, or 'Details' in
\code{\link{sjt.frq}}.}

\item{use.viewer}{Logical, if \code{TRUE}, the HTML table is shown in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{Logical, if \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}

\item{remove.spaces}{Logical, if \code{TRUE}, leading spaces are removed from all lines in the final string
that contains the html-data. Use this, if you want to remove parantheses for html-tags. The html-source
may look less pretty, but it may help when exporting html-tables to office tools.}
}
\value{
Invisibly returns
         \itemize{
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inline-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Shows the results of stacked frequencies (such as likert scales) as HTML table.
               This function is useful when several items with identical scale/categories
               should be printed as table to compare their distributions (e.g.
               when plotting scales like SF, Barthel-Index, Quality-of-Life-scales etc.).
}
\details{
See 'Details' in \code{\link{sjt.frq}}.
}
\note{
See 'Notes' in \code{\link{sjt.frq}}.
}
\examples{
# -------------------------------
# random sample
# -------------------------------
# prepare data for 4-category likert scale, 5 items
likert_4 <- data.frame(
  as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.2, 0.3, 0.1, 0.4))),
  as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.5, 0.25, 0.15, 0.1))),
  as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.25, 0.1, 0.4, 0.25))),
  as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.1, 0.4, 0.4, 0.1))),
  as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.35, 0.25, 0.15, 0.25)))
)

# create labels
levels_4 <- c("Independent", "Slightly dependent",
              "Dependent", "Severely dependent")

# create item labels
items <- c("Q1", "Q2", "Q3", "Q4", "Q5")

# plot stacked frequencies of 5 (ordered) item-scales
\dontrun{
sjt.stackfrq(likert_4, value.labels = levels_4, var.labels = items)

# -------------------------------
# Data from the EUROFAMCARE sample dataset
# Auto-detection of labels
# -------------------------------
library(sjmisc)
data(efc)
# recveive first item of COPE-index scale
start <- which(colnames(efc) == "c82cop1")
# recveive first item of COPE-index scale
end <- which(colnames(efc) == "c90cop9")

sjt.stackfrq(efc[, c(start:end)], altr.row.col = TRUE)

sjt.stackfrq(efc[, c(start:end)], altr.row.col = TRUE,
             show.n = TRUE, show.na = TRUE)

# --------------------------------
# User defined style sheet
# --------------------------------
sjt.stackfrq(efc[, c(start:end)], altr.row.col = TRUE,
             show.total = TRUE, show.skew = TRUE, show.kurtosis = TRUE,
             CSS = list(css.ncol = "border-left:1px dotted black;",
                        css.summary = "font-style:italic;"))}

}
\seealso{
\itemize{
             \item \href{http://www.strengejacke.de/sjPlot/sjt.stackfrq}{sjPlot manual: sjt-basics}
             \item \code{\link{sjp.stackfrq}}
             \item \code{\link{sjp.likert}}
             }
}
