% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_reduce.R
\name{sits_reduce}
\alias{sits_reduce}
\alias{sits_reduce.sits}
\alias{sits_reduce.raster_cube}
\title{Reduces a cube or samples from a summarization function}
\usage{
sits_reduce(data, ...)

\method{sits_reduce}{sits}(data, ...)

\method{sits_reduce}{raster_cube}(
  data,
  ...,
  impute_fn = impute_linear(),
  memsize = 4L,
  multicores = 2L,
  output_dir,
  progress = TRUE
)
}
\arguments{
\item{data}{Valid sits tibble or cube}

\item{...}{Named expressions to be evaluated (see details).}

\item{impute_fn}{Imputation function to remove NA values.}

\item{memsize}{Memory available for classification (in GB).}

\item{multicores}{Number of cores to be used for classification.}

\item{output_dir}{Directory where files will be saved.}

\item{progress}{Show progress bar?}
}
\value{
A sits tibble or a sits cube with new bands, produced
        according to the requested expression.
}
\description{
Apply a temporal reduction from a named expression in cube or sits tibble.
In the case of cubes, it materializes a new band in \code{output_dir}.
The result will be a cube with only one date with the raster reduced
from the function.
}
\details{
\code{sits_reduce()} allows valid R expression to compute new bands.
Use R syntax to pass an expression to this function.
Besides arithmetic operators, you can use virtually any R function
that can be applied to elements of a matrix.
The provided functions must operate at line level in order to perform
temporal reduction on a pixel.

\code{sits_reduce()} Applies a function to each row of a matrix.
In this matrix, each row represents a pixel and each column
represents a single date. We provide some operations already
implemented in the package to perform the reduce operation.
See the list of available functions below:
}
\note{
The \code{t_sum()}, \code{t_std()}, \code{t_skewness()},
 \code{t_kurtosis}, \code{t_mse} indexes generate values greater than
 the limit of a two-byte integer. Therefore, we save the images
 generated by these as Float-32 with no scale.
}
\section{Summarizing temporal functions}{

\itemize{
 \item{\code{t_max()}: Returns the maximum value of the series.}
 \item{\code{t_min()}: Returns the minimum value of the series}
 \item{\code{t_mean()}: Returns the mean of the series.}
 \item{\code{t_median()}: Returns the median of the series.}
 \item{\code{t_std()}: Returns the standard deviation of the series.}
 \item{\code{t_skewness()}: Returns the skewness of the series.}
 \item{\code{t_kurtosis()}: Returns the kurtosis of the series.}
 \item{\code{t_amplitude()}: Returns the difference between the maximum and
 minimum values of the cycle. A small amplitude means a stable cycle.}
 \item{\code{t_fslope()}: Returns the maximum value of the first slope of
 the cycle. Indicates when the cycle presents an abrupt change in the
 curve. The slope between two values relates the speed of the growth or
 senescence phases}
 \item{\code{t_mse()}: Returns the average spectral energy density.
 The energy of the time series is distributed by frequency.}
 \item{\code{t_fqr()}: Returns the value of the first quartile of the
 series (0.25).}
 \item{\code{t_tqr()}: Returns the value of the third quartile of the
 series (0.75).}
 \item{\code{t_iqr()}: Returns the interquartile range
 (difference between the third and first quartiles).}
}
}

\examples{
if (sits_run_examples()) {
    # Reduce summarization function

    point2 <-
        sits_select(point_mt_6bands, "NDVI") |>
        sits_reduce(NDVI_MEDIAN = t_median(NDVI))

    # Example of generation mean summarization from a cube
    # Create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )

    # Reduce NDVI band with mean function
    cube_mean <- sits_reduce(
        data = cube,
        NDVIMEAN = t_mean(NDVI),
        output_dir = tempdir()
    )
}

}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Rolf Simoes, \email{rolfsimoes@gmail.com}
}
