% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_mosaic.R
\name{sits_mosaic}
\alias{sits_mosaic}
\title{Mosaic classified cubes}
\usage{
sits_mosaic(
  cube,
  crs,
  roi = NULL,
  multicores = 2,
  output_dir = getwd(),
  version = "v1",
  progress = TRUE
)
}
\arguments{
\item{cube}{A sits data cube.}

\item{crs}{A target coordinate reference system of raster mosaic.
The provided crs could be a character
(e.g, "EPSG:4326" or a proj4string), or a
a numeric with the EPSG code (e.g. 4326).}

\item{roi}{Region of interest (see below).}

\item{multicores}{Number of cores that will be used to
crop the images in parallel.}

\item{output_dir}{Directory for output images.}

\item{version}{Version of resulting image
(in the case of multiple tests)}

\item{progress}{Show progress bar? Default is TRUE.}
}
\value{
a sits cube with only one tile.
}
\description{
Creates a mosaic of all tiles of a classified cube.
It is possible to provide a \code{roi} to cropping the mosaic.
If the \code{roi} parameter is supplied, each tile will be
cropped in parallel and the multicores parameter can be
used to define how many tiles will be cropped simultaneously.
}
\note{
The "roi" parameter defines a region of interest. It can be
   an sf_object, a shapefile, or a bounding box vector with
   named XY values ("xmin", "xmax", "ymin", "ymax") or
   named lat/long values ("lon_min", "lat_min", "lon_max", "lat_max")
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir,
        delim = "_",
        parse_info = c("X1", "tile", "band", "date")
    )
    # classify a data cube
    probs_cube <- sits_classify(data = cube, ml_model = rfor_model)
    # smooth the probability cube using Bayesian statistics
    bayes_cube <- sits_smooth(probs_cube)
    # label the probability cube
    label_cube <- sits_label_classification(bayes_cube)
    # create roi
    roi <- sf::st_sfc(
        sf::st_polygon(
          list(rbind(
            c(-55.64768, -11.68649),
            c(-55.69654, -11.66455),
            c(-55.62973, -11.61519),
            c(-55.64768, -11.68649)))), crs = 4326
    )
    # crop and mosaic classified image
    mosaic_cube <- sits_mosaic(
             cube = label_cube,
             roi = roi,
             crs = 4326
    )
}

}
\author{
Felipe Carvalho, \email{felipe.carvalho@inpe.br}

Rolf Simoes,     \email{rolf.simoes@inpe.br}
}
