% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_simulation.R
\name{plotSimulation}
\alias{plotSimulation}
\title{Plots the result of a simulation.}
\usage{
plotSimulation(simdf, molecules = NULL, inds = unique(simdf$Ind),
  trials = unique(simdf$trial), timeMin = min(simdf$time),
  timeMax = max(simdf$time), mergeAllele = T, mergePTM = T,
  mergeComplexes = F, yLogScale = T, nIndPerRow = 3,
  nCompPerRow = 10, ...)
}
\arguments{
\item{simdf}{The dataframe with the result of the simulation (see \code{\link{simulateInSilicoSystem}}).}

\item{molecules}{A vector of gene IDs (numeric or character) and/or complex IDs (e.g. CTC1) to be plotted.}

\item{inds}{A vector of in silico individual names for which to plot the expression profiles.}

\item{trials}{A vector of trials ID (= number) to use for the plot (see details).}

\item{timeMin}{Numeric. The minimum simulation time to plot. Default value set to the minimum time in the simulation.}

\item{timeMax}{Numeric. The maximum simulation time to plot. Default value set to the maximum time in the simulation.}

\item{mergeAllele}{Are the gene products originating from different alleles merged? Default TRUE. Also see \code{\link{mergeAlleleAbundance}}}

\item{mergePTM}{Are the modified and non-modified versions of the proteins merged? Default TRUE. Also see \code{\link{mergePTMAbundance}}}

\item{mergeComplexes}{Are the free and in complex gene products merged? Default FALSE. Also see \code{\link{mergeComplexesAbundance}}}

\item{yLogScale}{Plot the y-axis in log10-scale? If so, the abundance of each species at each time-point is increased by 1 to avoid zero values. Default TRUE.}

\item{nIndPerRow}{Positive integer, the number of individuals to plot per row. Default 3.}

\item{nCompPerRow}{Positive integer, the number of components to plot per row in the legend. Default 10.}

\item{...}{Any additional parameter to be passed to \code{\link[ggplot2]{theme}} for the plot of each individual.}
}
\value{
A plot from \code{\link[ggpubr]{ggarrange}}.
}
\description{
Automatically plots the result of a simulation (i.e. the abundance of RNAs, proteins and complexes over time)
for the selected in silico individuals.
}
\details{
If more than one trial is to be plotted, the mean abundance of each molecule over the different trials is plotted with a solid line,
and the min and max abundances represented as coloured areas around the mean.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 5, regcomplexes = "none", ploidy = 2)
mypop = createInSilicoPopulation(15, mysystem)
sim = simulateInSilicoSystem(mysystem, mypop, 100, ntrials = 5)
plotSimulation(sim$Simulation,
 c(1, 2, 3),
 c("Ind1", "Ind2", "Ind3", "Ind4"),
 axis.title = element_text(color = "red"))
}
}
