% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinx.R
\name{sinx}
\alias{sinx}
\title{Sino Xmen's sayings the R community.}
\usage{
sinx(which = NULL, sinxs.data = NULL, fixed = TRUE, showMatches = FALSE, 
    author = character(), ...)
}
\arguments{
\item{which}{an integer specifying the row number of `sinxs.data`. Alternatively `which`` can be a character and `grep`` is used to try to find a suitable row.}

\item{sinxs.data}{data frame containing a saying in each row. By default the data from the 'sinx' package are used.}

\item{fixed}{logical passed to `grep` if `which`` is a character, indicating if it should work (if `TRUE`, as by default) with a simple character string or (if `FALSE`) with regular expressions.}

\item{showMatches}{if `which` is character, a logical indicating if `sinx()` should print all the row numbers of `sinxs.data` which match the `grep` search.}

\item{author}{a character string to match (via `grep`) to the "authors" column of `sinxs.data`.}

\item{...}{potential further arguments passed to `grep`.}
}
\value{
an object of class "sinx" which is a row from a data frame of sayings (like those read in from read.sinxs).
}
\description{
Sino Xmen's sayings the R community.
}
\examples{
sinx()

for (i in 1:4) print(sinx(i))

path_f <- system.file("fortunes/fortunes.csv", package = "fortunes")
path_s <- system.file("sinxs/sinxs.csv", package = "sinx")
ftns <- sinx::read.sinxs(c(path_f, path_s), sep = c(";", ","))
sinx::sinx(sinxs.data = ftns)

jinyong <- read.sinxs(lib = "jinyong")
sinx(sinxs.data = jinyong)

libs <- read.sinxs(lib = c("tangshi", "songshi", "chinese", "yangsheng", "english", 
    "jinyong"))
sinx(sinxs.data = libs)
}
