% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strataEstimation.R
\name{stratifyPopsize}
\alias{stratifyPopsize}
\alias{stratifyPopsize.singleRStaticCountData}
\title{Estimate size of sub populations.}
\usage{
stratifyPopsize(object, stratas, alpha, ...)

\method{stratifyPopsize}{singleRStaticCountData}(object, stratas, alpha, cov = NULL, ...)
}
\arguments{
\item{object}{an object on which the population size estimates should be based
in \code{singleRcapture} package this is a fitter \code{singleRStaticCountData} class object.}

\item{stratas}{a specification of sub populations either by:
\itemize{
\item formula -- a formula to be applied to \code{model.frame} extracted from
the object .
\item Logical vector with number of entries equal to number of rows in the dataset.
\item A (named) list where each element is a logical vector, names of the list
will be used to specify names variable in returned object.
\item Vector of names of explanatory variables. For \code{singleRStaticCountData} method
for this function this specification of \code{stratas} parameter will
result in every level of explanatory variable having its own sub population
for each variable specified.
\item If no value was provided the \code{singleRStaticCountData} method for this function
will itself create sub populations based on levels of factor variables
in \code{model.frame}.
}}

\item{alpha}{significance level for confidence intervals --
Either a single numeric value or a vector of length equal to number of
sub populations specified in \code{stratas}.
If missing it is set to \code{.05} in \code{singleRStaticCountData} method.}

\item{...}{a vector of arguments to be passed to other functions.
For \code{singleRStaticCountData} method for this functions arguments in \code{...} are
passed to either \code{cov} if argument provided was a function or
\code{vcov} if \code{cov} argument was missing at call.}

\item{cov}{for \code{singleRStaticCountData} method an estimate of variance-covariance matrix
for estimate of regression parameters. It is possible to pass a function
such as for example \code{sandwich::vcovHC} which will be called as:
\code{foo(object, ...)} and a user may specify additional arguments of a
function in \code{...} argument. If not provided an estimate for covariance
matrix will be set by calling appropriate \code{vcov} method.}
}
\value{
A \code{data.frame} object with row names being the names of specified
sub populations either provided or inferred.
}
\description{
A function that estimates sizes of specific sub populations
based on a capture-recapture model for the whole population.
}
\details{
\loadmathjax

In single source capture-recapture models the most frequently used
estimate for population size is Horvitz-Thompson type estimate:

\mjsdeqn{\hat{N} = \sum_{k=1}^{N}\frac{I_{k}}{\mathbb{P}(Y_{k}>0)} = 
\sum_{k=1}^{N_{obs}}\frac{1}{1-\mathbb{P}(Y_{k}=0)}}

where \mjseqn{I_{k}=I_{Y_{k} > 0}} are
indicator variables, with value 1 if kth unit was observed at least once
and 0 otherwise and the inverse probabilistic weights weights for
units observed in the data \mjseqn{\tfrac{1}{\mathbb{P}(Y_{k}>0)}}
are estimated using fitted linear predictors.

The estimates for different sub populations are made by changing the
\mjseqn{I_{k}=I_{Y_{k} > 0}} indicator variables to
refer not to the population as a whole but to the sub populations that are
being considered i.e. by changing values from 1 to 0 if kth unit is not a
member of sub population that is being considered at the moment.

The estimation of variance for these estimates and estimation of variance for
estimate of population size for the whole population follow the same relation
as the one described above.
}
\seealso{
\code{\link[=vcov.singleRStaticCountData]{vcov.singleRStaticCountData()}} \code{\link[=estimatePopsize]{estimatePopsize()}}
}
