% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACF.R
\name{theo_acf}
\alias{theo_acf}
\title{Theoretical Autocorrelation (ACF) of an ARMA process}
\usage{
theo_acf(ar, ma = NULL, lagmax = 20)
}
\arguments{
\item{ar}{A \code{vector} containing the AR coefficients.}

\item{ma}{A \code{vector} containing the MA coefficients.}

\item{lagmax}{An \code{integer} indicating the maximum lag up to which to compute the theoretical ACF.}
}
\description{
This function computes the theoretical Autocorrelation (ACF) of an ARMA process.
}
\examples{
# Compute the theoretical ACF for an ARMA(1,0) (i.e. a first-order autoregressive model: AR(1))
theo_acf(ar = -0.25, ma = NULL)
# Computes the theoretical ACF for an ARMA(2, 1)
theo_acf(ar = c(.50, -0.25), ma = 0.20, lagmax = 10)
}
\author{
Yuming Zhang
}
