% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{AIC.fitsimts}
\alias{AIC.fitsimts}
\title{Akaike's Information Criterion}
\usage{
\method{AIC}{fitsimts}(object, k = 2, ...)
}
\arguments{
\item{object}{A fitsimts object.}

\item{k}{The penalty per parameter to be used; the default k = 2 is the classical AIC.}

\item{...}{Optionally more fitted model objects.}
}
\value{
AIC, BIC or HQ
}
\description{
This function calculates AIC, BIC or HQ for a fitsimts object. This function currently
only supports models estimated by the MLE.
}
\examples{
set.seed(1)
n = 300
Xt = gen_gts(n, AR(phi = c(0, 0, 0.8), sigma2 = 1))
mod = estimate(AR(3), Xt)

# AIC
AIC(mod)

# BIC
AIC(mod, k = log(n))

# HQ
AIC(mod, k = 2*log(log(n)))
}
\author{
Stéphane Guerrier
}
