% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACF.R
\name{corr_analysis}
\alias{corr_analysis}
\title{Correlation Analysis Functions}
\usage{
corr_analysis(x, lag.max = NULL, type = "correlation", demean = TRUE,
  show.ci = TRUE, alpha = 0.05, plot = TRUE, ...)
}
\arguments{
\item{x}{A \code{vector} or \code{"ts"} object (of length \eqn{N > 1}).}

\item{lag.max}{A \code{integer} indicating the maximum lag up to which to compute the ACF and PACF functions.}

\item{type}{A \code{character} string giving the type of acf to be computed. Allowed values are "correlation" (the default) and "covariance".}

\item{demean}{A \code{bool} indicating whether the data should be detrended (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{TRUE}.}

\item{show.ci}{A \code{bool} indicating whether to compute and show the confidence region. Defaults to \code{TRUE}.}

\item{alpha}{A \code{double} indicating the level of significance for the confidence interval. By default \code{alpha = 0.05} which gives a 1 - \code{alpha} = 0.95 confidence interval.}

\item{plot}{A \code{bool} indicating whether a plot of the computed quantities should be produced. Defaults to \code{TRUE}.}

\item{...}{Additional parameters.}
}
\value{
Two \code{array} objects (ACF and PACF) of dimension \eqn{N \times S \times S}{N x S x S}.
}
\description{
Correlation Analysis function computes and plots both empirical ACF and PACF
of univariate time series.
}
\examples{
# Estimate both the ACF and PACF functions
corr_analysis(datasets::AirPassengers)
}
\author{
Yunxiang Zhang
}
