% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_gs_n.R
\name{create_cut}
\alias{create_cut}
\title{Create a cutting function}
\usage{
create_cut(...)
}
\arguments{
\item{...}{Arguments passed to \code{\link[=get_analysis_date]{get_analysis_date()}}}
}
\value{
A function that accepts a data frame of simulated trial data and
returns a cut date
}
\description{
Create a cutting function for use with \code{\link[=sim_gs_n]{sim_gs_n()}}
}
\examples{
# Simulate trial data
trial_data <- sim_pw_surv()

# Create a cutting function that applies the following 2 conditions:
# - At least 45 months have passed since the start of the study
# - At least 300 events have occurred
cutting <- create_cut(
  planned_calendar_time = 45,
  target_event_overall = 350
)

# Cut the trial data
cutting(trial_data)
}
\seealso{
\code{\link[=get_analysis_date]{get_analysis_date()}}, \code{\link[=sim_gs_n]{sim_gs_n()}}
}
