% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pval_power_calib.R
\name{pval_power_calib}
\alias{pval_power_calib}
\title{Estimate calibrated power}
\usage{
pval_power_calib(pvals, causal_indexes, alpha = 0.05)
}
\arguments{
\item{pvals}{The vector of association p-values to analyze.
This function assumes all p-values are provided (a mix of null and alternative tests).
\code{NA} values are allowed in input and removed.
Non-\code{NA} values outside of [0, 1] will trigger an error.}

\item{causal_indexes}{The vector of causal indexes, defining the true classes used for calibrated power estimation.
Values of \code{causal_indexes} as returned by \code{sim_trait} work.
There must be at least one causal index and at least one non-causal case.}

\item{alpha}{The desired significance level (default 0.05).
May be a vector.}
}
\value{
The calibrated power estimates at each \code{alpha}
}
\description{
Given a significance level \code{alpha} and p-values with known causal status, this function estimates the calibrated power.
First it estimates the p-value threshold at which the desired type I error of \code{alpha} is achieved, then it uses this p-value threshold (not \code{alpha}) to estimate statistical power.
Note that these simple empirical estimates are likely to be inaccurate unless the number of p-values is much larger than \code{1/alpha}.
}
\examples{
# simulate truly null p-values, which should be uniform
pvals <- runif(10)
# for toy example, take the first two p-values to be truly causal
causal_indexes <- 1:2
# estimate desired measure
pval_power_calib( pvals, causal_indexes )

}
\seealso{
\code{\link[=pval_aucpr]{pval_aucpr()}}, a robust proxy for calibrated power that integrates across significance thresholds.
}
