# simData: A constructor of data object

setMethod("simData", signature(param = "SimSet"), definition = function(param, n = NULL, misspec = new("NullSimMisspec"), equalCon = new("NullSimEqualCon"), 
    maxDraw = 100, sequential = FALSE, facDist = new("NullSimDataDist"), errorDist = new("NullSimDataDist"), indDist = new("NullSimDataDist"), 
    indLab = new("NullVector"), modelBoot = FALSE, realData = new("NullDataFrame")) {
    modelType <- param@modelType
    if (!(is.na(sequential) | sequential == TRUE | sequential == FALSE)) 
        stop("Please specify NA (to use default), TRUE, or FALSE for the sequential argument")
    if (is.na(sequential)) 
        sequential <- FALSE
    if (!isNullObject(misspec)) {
        if (modelType != misspec@modelType) 
            stop("SimMisspec and SimSet do not have the same tag")
    }
    if (!isNullObject(equalCon)) {
        if (modelType != equalCon@modelType) 
            stop("SimEqualCon and SimSet do not have the same tag")
    }
    if (modelBoot) {
        if (sequential) 
            stop("The model-based bootstrap and sequential cannot be used at the same time.")
        if (isNullObject(realData)) 
            stop("If the data are generated by model bootstrap, the real data are needed.")
        if (!isNullObject(indLab)) 
            realData <- realData[, indLab]
        if (sum(is.na(realData)) > 0) 
            stop("The model-based bootstrap is not available for data with missingness.")
    }
    if (is.null(n)) 
        n <- nrow(realData)
    if (!isNullObject(errorDist)) {
        if (modelType == "Path" | modelType == "Path.exo") 
            stop("errorDist is not allowed for path analysis model. The distribution of each indicator should be specified in facDist if sequential=TRUE.")
    }
    if (!sequential & !isNullObject(facDist)) 
        stop("facDist is not allowed when using model-implied method in data generation")
    if (!sequential & !isNullObject(errorDist)) 
        stop("errorDist is not allowed when using model-implied method in data generation")
    if (sequential & !isNullObject(indDist)) 
        stop("indDist is not allowed when using sequential method in data generation")
    return(new("SimData", n = n, modelType = modelType, param = param, misspec = misspec, equalCon = equalCon, maxDraw = maxDraw, sequential = sequential, 
        facDist = facDist, errorDist = errorDist, indDist = indDist, indLab = indLab, modelBoot = modelBoot, realData = realData))
})

setMethod("simData", signature(param = "SimModelOut"), definition = function(param, misspec = new("NullSimMisspec"), maxDraw = 100, 
    sequential = FALSE, facDist = new("NullSimDataDist"), errorDist = new("NullSimDataDist"), indDist = new("NullSimDataDist"), usedStd = TRUE, 
    modelBoot = FALSE, realData = new("NullDataFrame")) {
    n <- param@n
    modelType <- param@coef@modelType
    equalCon <- param@equalCon
    usedParam <- toSimSet(param, usedStd = usedStd)
    indLab <- param@indLab
    result <- simData(param = usedParam, n = n, misspec = misspec, equalCon = equalCon, maxDraw = maxDraw, sequential = sequential, facDist = facDist, 
        errorDist = errorDist, indDist = indDist, indLab = indLab, modelBoot = modelBoot, realData = realData)
    return(result)
})


setMethod("simData", signature(param = "SimRSet"), definition = function(param, n = NULL, misspec = new("NullSimMisspec"), 
    equalCon = new("NullSimEqualCon"), maxDraw = 100, sequential = FALSE, facDist = new("NullSimDataDist"), errorDist = new("NullSimDataDist"), 
    indDist = new("NullSimDataDist"), usedStd = TRUE, modelBoot = FALSE, realData = new("NullDataFrame")) {
    if (is.null(n)) 
        stop("Please provide the desired sample size.")
    usedParam <- toSimSet(param)
    result <- simData(param = usedParam, n = n, misspec = misspec, equalCon = equalCon, maxDraw = maxDraw, sequential = sequential, facDist = facDist, 
        errorDist = errorDist, indDist = indDist, indLab = indLab, modelBoot = modelBoot, realData = realData)
    return(result)
}) 
