% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simrel.R
\name{simrel}
\alias{simrel}
\title{Simulation of Multivariate Linear Model Data}
\usage{
simrel(n, p, q, relpos, gamma, R2, type = "univariate", ...)
}
\arguments{
\item{n}{Number of observations.}

\item{p}{Number of variables.}

\item{q}{An integer for univariate, a vector of 3 integers for bivariate and 3 or more for multivariate simulation (for details see Notes).}

\item{relpos}{A list (vector in case of univariate simulation) of position of relevant component for predictor variables corresponding to each response.}

\item{gamma}{A declining (decaying) factor of eigenvalues of predictors (X). Higher the value of \code{gamma}, the decrease of eigenvalues will be steeper.}

\item{R2}{Vector of coefficient of determination (proportion of variation explained by predictor variable) for each relevant response components.}

\item{type}{Type of simulation - \code{univariate}, \code{bivariate} and \code{multivariate}}

\item{...}{Since this is a wrapper function to simulate univariate, bivariate or multivariate, it calls their respective function. This parameter should contain all the necessary arguements for respective simulations. See \code{\link{unisimrel}}, \code{\link{bisimrel}} and \code{\link{multisimrel}}}
}
\value{
A simrel object with all the input arguments along with following additional items.
    \item{X}{Simulated predictors}
    \item{Y}{Simulated responses}
    \item{W}{Simulated predictor components}
    \item{Z}{Simulated response components}
    \item{beta}{True regression coefficients}
    \item{beta0}{True regression intercept}
    \item{relpred}{Position of relevant predictors}
    \item{testX}{Test Predictors}
    \item{testY}{Test Response}
    \item{testW}{Test predictor components}
    \item{testZ}{Test response components}
    \item{minerror}{Minimum model error}
    \item{Xrotation}{Rotation matrix of predictor (R)}
    \item{Yrotation}{Rotation matrix of response (Q)}
    \item{type}{Type of simrel object \emph{univariate} or \emph{multivariate}}
    \item{lambda}{Eigenvalues of predictors}
    \item{SigmaWZ}{Variance-Covariance matrix of components of response and predictors}
    \item{SigmaWX}{Covariance matrix of response components and predictors}
    \item{SigmaYZ}{Covariance matrix of response and predictor components}
    \item{Sigma}{Variance-Covariance matrix of response and predictors}
    \item{RsqW}{Coefficient of determination corresponding to response components}
    \item{RsqY}{Coefficient of determination corresponding to response variables}
}
\description{
Simulation of Multivariate Linear Model Data
}
\references{
Sæbø, S., Almøy, T., & Helland, I. S. (2015). simrel—A versatile tool for linear model data simulation based on the concept of a relevant subspace and relevant predictors. Chemometrics and Intelligent Laboratory Systems, 146, 128-135.

Almøy, T. (1996). A simulation study on comparison of prediction methods when only a few components are relevant. Computational statistics & data analysis, 21(1), 87-107.
}
\keyword{data}
\keyword{linear}
\keyword{model}
\keyword{model,}
\keyword{simulation,}
