% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breaks.R
\name{x_numeric_breaks}
\alias{x_numeric_breaks}
\title{Calculate the breaks for a x axis numeric vector.}
\usage{
x_numeric_breaks(x_var_vctr, x_balance = FALSE, x_pretty_n = 6,
  x_trans = "identity", x_zero = TRUE, mobile = FALSE)
}
\arguments{
\item{x_var_vctr}{A numeric vector for the x scale from which to determine breaks from.}

\item{x_balance}{Add balance to the y axis so that zero is in the centre of the x scale.}

\item{x_pretty_n}{The desired number of intervals on the x axis, as calculated by the pretty algorithm. Defaults to 6.}

\item{x_trans}{A string specifying a transformation for the x axis scale, such as "log10" or "sqrt". Defaults to "identity".}

\item{x_zero}{TRUE or FALSE of whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{mobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. If within an app with the mobileDetect function, then use mobile = input$mobile.}
}
\value{
A vector of breaks
}
\description{
Calculate the breaks for a x axis numeric vector.
}
