% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simode_profile.R
\name{profile.simode}
\alias{profile.simode}
\title{Calculate likelihood profiles for the model parameters}
\usage{
\method{profile}{simode}(fitted, which = NULL, optim_type = c("nls",
  "both"), step_size, max_steps = 100, alpha = 0.05, skip_err = T,
  trace = 0, save_to_log = F, ...)
}
\arguments{
\item{fitted}{\code{simode} object returned by a call to \code{\link{simode}}.}

\item{which}{Which parameters to estimate the profile for.}

\item{optim_type}{Whether to calculate the profiles based on
maximum-likelihood optimization only ('nls') or based on integral-matching
followed by maximum-likelihood optimization ('both').}

\item{step_size}{Step size for profiling (one value for all parameters or
a value for each parameter in \code{which}).}

\item{max_steps}{Maximum number of steps to take in each direction.}

\item{alpha}{Maximum (two-sided) likelihood ratio test confidence level to find.}

\item{skip_err}{Whether on not to stop the calculation if encountering a problem
with one point in the profile.}

\item{trace}{Report level (0-4), with higher values producing more tracing information.}

\item{save_to_log}{Whether to redirect output to log file. The log file
will be saved to tempdir().}

\item{...}{Additional argument(s) for methods.}
}
\value{
The likelihood profiles.
}
\description{
Calculate likelihood profiles for the model parameters
}
\details{
If the call to \code{\link{simode}}, which returned the fitted object given to
this method, included a user-defined likelihood function (with the \code{calc_nll} argument),
then the likelihood profiles will be calculated using this function. Otherwise,
the profiles will be calculated using a likelihood based on a Gaussian distribuion
with fixed sigma, where sigma will be estimated in the background together with
the rest of the model parameters.
}
