% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectory-activities.R
\name{send}
\alias{send}
\alias{trap}
\alias{untrap}
\alias{wait}
\title{Inter-arrival Communication}
\usage{
send(.trj, signals, delay = 0)

trap(.trj, signals, handler = NULL, interruptible = TRUE)

untrap(.trj, signals)

wait(.trj)
}
\arguments{
\item{.trj}{the trajectory object.}

\item{signals}{signal or list of signals, accepts either a string, a list of
strings or a callable object (a function) which must return a string or a
list of strings.}

\item{delay}{optional timeout to trigger the signals, accepts either a
numeric or a callable object (a function) which must return a numeric.}

\item{handler}{optional trajectory object to handle a signal received.}

\item{interruptible}{whether the handler can be interrupted by signals.}
}
\value{
Returns the trajectory object.
}
\description{
These activities enable asynchronous programming. \code{send()} broadcasts a
signal or a list of signals. Arrivals can subscribe to signals and (optionally)
assign a handler with \code{trap()}. Note that, while inside a batch, all the
signals subscribed before entering the batch are ignored. Upon a signal
reception, the arrival stops the current activity and executes the handler
(if provided). Then, the execution returns to the activity following the
point of the interruption. \code{untrap()} can be used to unsubscribe from
signals. \code{wait()} blocks until a signal is received.
}
\examples{
## block, signal and continue with a handler
signal <- "you shall pass"

t_blocked <- trajectory() \%>\%
  trap(
    signal,
    trajectory() \%>\%
      log_("executing the handler")) \%>\%
  log_("waiting...") \%>\%
  wait() \%>\%
  log_("continuing!")

t_signaler <- trajectory() \%>\%
  log_(signal) \%>\%
  send(signal)

simmer() \%>\%
  add_generator("blocked", t_blocked, at(0)) \%>\%
  add_generator("signaler", t_signaler, at(5)) \%>\%
  run() \%>\% invisible

## handlers can be interrupted, unless interruptible=FALSE
t_worker <- trajectory() \%>\%
  trap(
  signal,
  handler = trajectory() \%>\%
    log_("ok, I'm packing...") \%>\%
    timeout(1)) \%>\%
  log_("performing a looong task...") \%>\%
  timeout(100) \%>\%
  log_("and I'm leaving!")

simmer() \%>\%
  add_generator("worker", t_worker, at(0)) \%>\%
  add_generator("signaler", t_signaler, at(5, 5.5)) \%>\%
  run() \%>\% invisible

}
\seealso{
\code{\link{renege_if}}
}
