% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{run}
\alias{run}
\alias{stepn}
\title{Run a Simulation}
\usage{
run(.env, until = Inf, progress = NULL, steps = 10)

stepn(.env, n = 1)
}
\arguments{
\item{.env}{the simulation environment.}

\item{until}{stop time.}

\item{progress}{optional callback to show the progress of the simulation. The
completed ratio is periodically passed as argument to the callback.}

\item{steps}{number of steps to show as progress (it takes effect only if
\code{progress} is provided).}

\item{n}{number of events to simulate.}
}
\value{
Returns the simulation environment.
}
\description{
Execute steps until a given criterion.
}
\examples{
## show the progress just printing the steps
simmer() \%>\%
  run(progress=message, steps=5)

## using the 'progress' package
\dontrun{
mm1 <- trajectory() \%>\%
  seize("server", 1) \%>\%
  timeout(function() rexp(1, 66)) \%>\%
  release("server", 1)

simmer() \%>\%
  add_resource("server", 1) \%>\%
  add_generator("customer", mm1, function() rexp(100, 60)) \%>\%
  run(3000, progress=progress::progress_bar$new()$update)
}

}
\seealso{
\code{\link{reset}}.
}
