% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simmer-methods.R
\name{simmer}
\alias{simmer}
\title{Create a Simulator}
\usage{
simmer(name = "anonymous", verbose = FALSE)
}
\arguments{
\item{name}{the name of the simulator.}

\item{verbose}{enable showing activity information.}
}
\value{
Returns a simulation environment.
}
\description{
This method initialises a simulation environment.
}
\examples{
t0 <- trajectory("my trajectory") \%>\%
  ## add an intake activity
  seize("nurse", 1) \%>\%
  timeout(function() rnorm(1, 15)) \%>\%
  release("nurse", 1) \%>\%
  ## add a consultation activity
  seize("doctor", 1) \%>\%
  timeout(function() rnorm(1, 20)) \%>\%
  release("doctor", 1) \%>\%
  ## add a planning activity
  seize("administration", 1) \%>\%
  timeout(function() rnorm(1, 5)) \%>\%
  release("administration", 1)

env <- simmer("SuperDuperSim") \%>\%
  add_resource("nurse", 1) \%>\%
  add_resource("doctor", 2) \%>\%
  add_resource("administration", 1) \%>\%
  add_generator("patient", t0, function() rnorm(1, 10, 2)) \%>\%
  run(until=80)

}
\seealso{
Methods for dealing with a simulation environment:
\code{\link{reset}}, \code{\link{now}}, \code{\link{peek}}, \code{\link{stepn}}, \code{\link{run}},
\code{\link{add_resource}}, \code{\link{add_generator}}, \code{\link{get_mon_arrivals}},
\code{\link{get_mon_attributes}}, \code{\link{get_mon_resources}}, \code{\link{get_n_generated}},
\code{\link{get_capacity}}, \code{\link{get_queue_size}},
\code{\link{get_server_count}}, \code{\link{get_queue_count}}.
}
