% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator-methods.R
\name{get_n_generated}
\alias{get_n_generated}
\alias{get_name}
\alias{get_attribute}
\alias{get_global}
\alias{get_prioritization}
\title{Get Process Parameters}
\usage{
get_n_generated(.env, generator)

get_name(.env)

get_attribute(.env, keys, global = FALSE)

get_global(.env, keys)

get_prioritization(.env)
}
\arguments{
\item{.env}{the simulation environment.}

\item{generator}{the name of the generator.}

\item{keys}{the attribute name(s).}

\item{global}{if \code{TRUE}, the attribute will be global instead of per-arrival.}
}
\description{
Getters for processes (generators and arrivals) number of arrivals generated
by a generator, the name of the active arrival, an attribute from the active
arrival or a global one, and prioritization values.
}
\details{
\code{get_n_generated} returns the number of arrivals generated by a
given generator.

\code{get_name} returns the number of the running arrival. \code{get_attribute}
returns a running arrival's attributes or global ones. If a provided key was
not previously set, it returns a missing value. \code{get_global} is a shortcut
for \code{get_attribute(global=TRUE)}. \code{get_prioritization} returns a
running arrival's prioritization values. \code{get_name}, \code{get_attribute}
and \code{get_prioritization} are meant to be used inside a trajectory; otherwise,
there will be no arrival running and these functions will throw an error.
}
\seealso{
\code{\link{set_attribute}}, \code{\link{set_prioritization}}.
}
